<?php

namespace App\Console\Commands;

use App\Services\HappyCallsService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class HappyCallsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'happy:calls';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command for fetching data who has purchase product in last 7 days';

    /**
     * Execute the console command.
     *
     * @return int
     */
    private $happyCallsService;

    public function handle(HappyCallsService $happyCallsService)
    {
        Log::info('happy calls fetching started : ' . Carbon::now());
        $happyCallsService->fetchData();
        Log::info('happy calls fetching end : ' . Carbon::now());
    }
}
