<?php

namespace App\Console\Commands;

use App\Services\Transactions\SendCouponCodeService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class SendCouponCodeCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:coupon';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'send coupon code to customer';

    /**
     * Execute the console command.
     *
     * @return int
     */
    private $sendCouponCodeService;

    public function handle(SendCouponCodeService $sendCouponCodeService)
    {
        Log::info('sending coupon code started : ' . Carbon::now());
        $sendCouponCodeService->sendCouponCode();
        Log::info('sending coupon code end : ' . Carbon::now());
    }
}
