<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('fetch:graythr')->dailyAt('10:31');
        $schedule->command('call:allocate')->dailyAt('11:00');
        $schedule->command('send:coupon')->everyFifteenMinutes();
        $schedule->command('excel:campaign')->everyFifteenMinutes();
        $schedule->command('backup:run --only-db')->daily()->at('01:00');
        $schedule->command('backup:clean')->daily()->at('02:00');
        $schedule->command('audio:process')
            ->between('22:00', '23:00')
            ->everyTenMinutes();
        // $schedule->command('happy:calls')->dailyAt('01:00');
        // $schedule->command('backup:run --only-db')->daily();
        // $schedule->command('database:backup')->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
