<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Session\TokenMismatchException;
use Throwable;
use Symfony\Component\HttpKernel\Exception\HttpException;

class Handler extends ExceptionHandler
{
    protected $levels = [
        //
    ];

    protected $dontReport = [
        //
    ];

    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $exception)
    {
        if ($request->is('api/*')) {
            if ($exception instanceof \Illuminate\Auth\AuthenticationException) {
                return response()->json(['message' => 'Unauthenticated. Token has expired or is invalid.'], 401);
            }

            if ($exception instanceof TokenMismatchException) {
                return response()->json(['message' => 'CSRF token mismatch. Your session may have expired.'], 419);
            }

            if ($exception instanceof HttpException && $exception->getStatusCode() === 419) {
                return response()->json(['message' => 'Page expired. Please refresh and try again.'], 419);
            }
        }

        return parent::render($request, $exception);
    }
}
