<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class CRMReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
            $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);

            $sheet->setCellValue('A4', 'Cluster');
            $sheet->setCellValue('B4', 'Branch');
            $sheet->setCellValue('C4', 'Date');
            $sheet->setCellValue('D4', 'Name');
            $sheet->setCellValue('E4', 'Mobile');
            $sheet->setCellValue('F4', 'Email');
            $sheet->setCellValue('G4', 'Location');
            $sheet->setCellValue('H4', 'Product Enquired');
            $sheet->setCellValue('I4', 'Department');
            $sheet->setCellValue('J4', 'Category');
            $sheet->setCellValue('K4', 'Users');
            $sheet->setCellValue('L4', 'Source');
            $sheet->setCellValue('M4', 'Type');
            $sheet->setCellValue('N4', 'Priority');
            $sheet->setCellValue('O4', 'Expected Date');
            $sheet->setCellValue('P4', 'Expected Price');
            $sheet->setCellValue('Q4', 'Offer Price');
            $sheet->setCellValue('R4', 'Comment');
            $sheet->setCellValue('S4', 'Read Status');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);

            $sheet->getStyle('A4:S4')->applyFromArray($bold);

            $rows = 5;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->clusterName);
                $sheet->setCellValue('B' . $rows, $val->branchName);
                $sheet->setCellValue('C' . $rows, AppDateTimeFormat($val->created_at));
                $sheet->setCellValue('D' . $rows, $val->customer_name);
                $sheet->setCellValue('E' . $rows, $val->mobile);
                $sheet->setCellValue('F' . $rows, $val->email);
                $sheet->setCellValue('G' . $rows, $val->location);
                $sheet->setCellValue('H' . $rows, $val->product_enquiry);
                $sheet->setCellValue('I' . $rows, $val->department);
                $sheet->setCellValue('J' . $rows, $val->ticket_category);
                $sheet->setCellValue('K' . $rows, $val->users);
                $sheet->setCellValue('L' . $rows, $val->ticket_source);
                $sheet->setCellValue('M' . $rows, $val->ticket_type);
                $sheet->setCellValue('N' . $rows, $val->priority);
                $sheet->setCellValue('O' . $rows, $val->expected_date);
                $sheet->setCellValue('P' . $rows, $val->expected_price);
                $sheet->setCellValue('Q' . $rows, $val->offer_price);
                $sheet->setCellValue('R' . $rows, $val->ticket_comment);
                $sheet->setCellValue('S' . $rows, $val->readStatus);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="crm-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('CRM report export error : ' . $e);
        }
    }

}
