<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class ResolvedReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . $data->fromDateLabel . ' to ' . $data->toDateLabel);
            $sheet->setCellValue('A2', 'Scheme : ' . $data->schemeLabel);
            $sheet->setCellValue('A3', 'Program : ' . $data->programLabel);
            $sheet->setCellValue('A4', 'District : ' . $data->districtLabel);
            $sheet->setCellValue('A5', 'Block : ' . $data->blockLabel);

            $sheet->setCellValue('A8', 'Feedback ID');
            $sheet->setCellValue('B8', 'Ben Name');
            $sheet->setCellValue('C8', 'Mobile');
            $sheet->setCellValue('D8', 'Program');
            $sheet->setCellValue('E8', 'District');
            $sheet->setCellValue('F8', 'Block');
            $sheet->setCellValue('G8', 'Sector');
            $sheet->setCellValue('H8', 'AWC');
            $sheet->setCellValue('I8', 'Resolved By');
            $sheet->setCellValue('J8', 'Resolved At');
            $sheet->setCellValue('K8', 'Resolved Level');
            $sheet->setCellValue('L8', 'Resolved Remarks');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);
            $sheet->getStyle('A4')->applyFromArray($heading);
            $sheet->getStyle('A5')->applyFromArray($heading);

            $sheet->getStyle('A8:L8')->applyFromArray($bold);

            $rows = 9;

            foreach ($data->items as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->feedback_no);
                $sheet->setCellValue('B' . $rows, $val->parent_name);
                $sheet->setCellValue('C' . $rows, $val->mobile_number);
                $sheet->setCellValue('D' . $rows, $val->programName);
                $sheet->setCellValue('E' . $rows, $val->cityName);
                $sheet->setCellValue('F' . $rows, $val->blockName);
                $sheet->setCellValue('G' . $rows, $val->sectorName);
                $sheet->setCellValue('H' . $rows, $val->awc);
                $sheet->setCellValue('I' . $rows, $val->resolvedBy);
                $sheet->setCellValue('J' . $rows, AppDateTimeFormat($val->created_at));
                $sheet->setCellValue('K' . $rows, $val->resolved_level);
                $sheet->setCellValue('L' . $rows, $val->resolvedRemarks);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="resolve-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('resolve report export error : ' . $e);
        }
    }
}
