<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\BaseController as BaseController;
use App\Http\Resources\CallsResource;
use App\Models\Transactions\CallHistory;
use App\Services\CallHistoryService;
use Illuminate\Http\Request;
use Validator;

class CallHistoryController extends BaseController
{

    private $callHistoryService;

    public function __construct(CallHistoryService $callHistoryService)
    {
        $this->callHistoryService = $callHistoryService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $products = Product::all();

        // return $this->sendResponse(ProductResource::collection($products), 'Products Retrieved Successfully.');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $input = $request->all();

        // $validator = Validator::make($input, [
        //     'type' => 'required',
        //     'customer_number' => 'required',
        //     'called_number' => 'required',
        //     'agent_number' => 'required',
        //     'call_status' => 'required',
        //     // 'call_transfer_status' => 'required',
        //     // 'customer_status' => 'required',
        //     // 'agent_status' => 'required',
        //     'call_uuid' => 'required',
        //     'recording_url' => 'required',
        //     'call_timestamp' => 'required',
        //     'call_duration' => 'required',
        //     'call_hang_up_by' => 'required'
        // ]);

        // if ($validator->fails()) {
        //     return $this->sendError('Validation Error.', $validator->errors());
        // }

        // $callNo = $this->commonService->generateUniqueScreenNumber(CallHistory::SCREEN_CALL_HISTORY);
        // $input['call_no'] = $callNo;
        // $call = CallHistory::create($input);
        // if ($call['id']) {
        //     unset($call['call_no']);
        //     // $this->commonService->updateUniqueScreenNumber(CallHistory::SCREEN_CALL_HISTORY);
        //     return $this->sendResponse(new CallsResource($call), 'Call history created successfully.');
        // } else {
        //     return $this->sendError('failed to create call history contact admin');
        // }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // $product = Product::find($id);

        // if (is_null($product)) {
        //     return $this->sendError('Product not found.');
        // }

        // return $this->sendResponse(new ProductResource($product), 'Product Retrieved Successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // $input = $request->all();

        // $validator = Validator::make($input, [
        //     'name' => 'required',
        //     'detail' => 'required'
        // ]);

        // if($validator->fails()){
        //     return $this->sendError('Validation Error.', $validator->errors());
        // }
        // $product = Product::find($id);
        // $product->name = $input['name'];
        // $product->detail = $input['detail'];
        // $product->save();

        // return $this->sendResponse(new ProductResource($product), 'Product Updated Successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // $product = Product::find($id);
        // $product->delete();

        // return $this->sendResponse([], 'Product Deleted Successfully.');
    }

    function pushCallLog(Request $request)
    {
        return $this->callHistoryService->pushCallLog($request);
    }

    function employeewiseAttendance(Request $request)
    {
        $data = $this->callHistoryService->employeewiseAttendance($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    function overallAttendance(Request $request)
    {
        $data = $this->callHistoryService->overallAttendance($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }
}
