<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\BaseController as BaseController;
use App\Imports\CreateAgents;
use App\Imports\CreateTickets;
use App\Imports\CreateCrmBrands;
use App\Imports\CreateCrmProducts;
use App\Models\ExcelCampaign;
use App\Models\Transactions\BeneficiaryImport;
use App\Services\CommonService;
use DB;
use Excel;
use Illuminate\Support\Facades\Artisan;

class TestController extends BaseController
{

    private $commonService;
    private $branchId;
    const EMPTY_CAMPAIGN_LEAD_ASSIGN_BRANCHS = [5, 6, 15, 17, 23, 24];

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
        $this->branchId = [];
    }

    public function createAgentsFromExcel()
    {
        try {
            DB::beginTransaction();
            $path = storage_path() . '/app/public/imports/agents/agents_04_10_2024.csv';
            Excel::import(new CreateAgents, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
        }
    }
    public function createTicketsFromExcel()
    {
        try {
            DB::beginTransaction();
            $path = storage_path('app/public/imports/tickets/Book1.xlsx');
            Excel::import(new CreateTickets, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            // dd($e);
        }
    }
    public function createCrmBrandsFromExcel()
    {
        try {
            DB::beginTransaction();
            $path = storage_path('app/public/imports/brands/Brand.xlsx');
            Excel::import(new CreateCrmBrands, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            // dd($e);
        }
    }
    public function createCrmProductsFromExcel()
    {
        try {
            DB::beginTransaction();
            $path = storage_path('app/public/imports/products/Products.xlsx');
            Excel::import(new CreateCrmProducts, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            // dd($e);
        }
    }
    function autoCallAllocation()
    {
        Artisan::call('call:allocate');
    }

    function assignExcelLeadsToBranch()
    {
        $branches = collect(self::EMPTY_CAMPAIGN_LEAD_ASSIGN_BRANCHS);
        $branchLoad = ExcelCampaign::whereIn('branch_id', $branches)
            ->select('branch_id', DB::raw('COUNT(*) as total'))
            ->where('created_at', '<=', '2025-10-10')
            ->groupBy('branch_id')
            ->pluck('total', 'branch_id');

        // initialize missing branches
        $branches->each(function ($branchId) use (&$branchLoad) {
            if (! $branchLoad->has($branchId)) {
                $branchLoad = $branchLoad->put($branchId, 0);
            }
        });

        // assign leads
        $unassigned = ExcelCampaign::where('branch_id', 32)->where('created_at', '<=', '2025-10-10')->get();
        foreach ($unassigned as $lead) {
            // sort branches by load and pick the first key
            $branchId = $branchLoad->sort()->keys()->first();

            $lead->branch_id = $branchId;
            $lead->save();
            if ($lead->id) {
                $customer = BeneficiaryImport::where('excel_campaign_id', $lead->id)->first();
                if ($customer) {
                    $customer->branch_id = $branchId;
                    $customer->save();
                    if (!in_array($branchId, $this->branchId)) {
                        array_push($this->branchId, $branchId);
                    }

                    // update the load count
                    $branchLoad = $branchLoad->put($branchId, $branchLoad[$branchId] + 1);
                }
            }
        }
    }
}
