<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Artisan;

class ArtisanCmdController extends Controller
{
    public function index($type)
    {
        switch ($type) {
            case 'cache-clear':
                $this->clearAppCache();
                break;
            case 'optimize-clear':
                $this->OptimizeClear();
                break;
            case 'key':
                $this->createAppKey();
                break;
            default:
                $this->clearAppCache();
                break;
        }
    }

    public function OptimizeClear()
    {
        Artisan::call('optimize:clear');
        echo 'Optimize cache cleared' . '<br>';
    }

    public function clearAppCache()
    {
        Artisan::call('config:cache');
        echo 'Config cache cleared' . '<br>';
        Artisan::call('optimize:clear');
        echo 'Optimize cache cleared' . '<br>';
        // Artisan::call('route:clear');
        // echo 'Route cache cleared' . '<br>';
        // Artisan::call('route:cache');
        // echo 'Route cached' . '<br>';
    }

    public function createAppKey()
    {
        Artisan::call('key:generate');
        echo 'App key generated' . '<br>';
    }
}
