<?php

namespace App\Http\Controllers;

use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\ClusterMaster;
use App\Services\DashboardService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DashboardController extends Controller
{

    public $dashboardService;
    public $privilegeService;
    public $dataTableService;

    public function __construct(DashboardService $dashboardService, PrivilegeService $privilegeService, DataTableService $dataTableService)
    {
        $this->dashboardService = $dashboardService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    public function index()
    {
        $data = $this->dashboardService->getLoggedInUserDashboard();
        return view($data->view, compact('data'));
    }

    public function getDashboardData(Request $request)
    {
        return $this->dashboardService->getDashboardData($request);
    }

    function appUserDashboard(Request $request)
    {
        return $this->dashboardService->appUserDashboard($request);
    }

    public function getBranches(Request $request)
    {
        return $this->dashboardService->getBranches($request);
    }
    
    public function detailedReport($type = null, $fromDate = null, $toDate = null, $cluster = null, $branch = null, $agent = null)
    {
        $data = $this->privilegeService->getPrivilegeDetails('reports');
        $data->fieldType = $type;
        $data->fromDate = $fromDate;
        $data->toDate = $toDate;
        $data->cluster = $cluster;
        $data->branch = $branch;
        $data->agent = $agent;
        $data->import = false;
        $data->breadcrumbTitle = "Detailed Report";
        $data->breadcrumbAction = route('dashboard');

        $data->fromDateLabel = Carbon::parse($fromDate)->format('m/d/Y');
        $data->toDateLabel = Carbon::parse($toDate)->format('m/d/Y');
        $data->clusterLabel = $cluster;
        $data->branchLabel = $branch;
        $data->agentLabel = $agent;

        if ($cluster != 'All') {
            $details = ClusterMaster::find($cluster);
            $data->clusterLabel = $details->name;
        }
        if ($branch != 'All') {
            $details = BranchMaster::find($branch);
            $data->branchLabel = $details->name;
        }
        if ($agent != 'All') {
            $details = AgentMaster::find($agent);
            $data->agentLabel = $details->name;
        }
        $data->type = 'dashboardDetailedReport';
        return $this->dashboardService->getDetailedReport($data);
        // return view('reports.dashboard-detailed-report', compact('data'));
    }


}
