<?php

namespace App\Http\Controllers;

use App\Models\Masters\UserMaster;
use App\Models\User;
use App\Services\Master\MenuService;
use App\Services\UserService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Session;
use Illuminate\Support\Facades\Cache;

class LoginController extends Controller
{

    private $menuService;
    private $userService;

    public function __construct(MenuService $menuService, UserService $userService)
    {
        $this->menuService = $menuService;
        $this->userService = $userService;
    }

    public function index()
    {
        return view('login');
    }

    public function checkLogin(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            $role = Auth::user()->role;
            $this->menuService->getRoleMenus($role);
            $this->setCRMSession();
            return redirect()->intended('dashboard')
                ->withSuccess('You have Successfully loggedin');
        }

        Session::flash('danger', 'Opps! You have entered invalid credentials');
        return redirect("login");
    }

    function setCRMSession()
    {
        $user = Auth::user();
        if ($user) {
            if ($user->role == 9) {
                $data = UserMaster::find($user->reference_id);
                if ($data) {
                    Session::put('crmBranch', $data->branch_id);
                }
            }
        }
    }

    public function logout()
    {
        $userId = auth()->id();
        Cache::forget("menus_user_{$userId}");

        Session::flush();

        Auth::logout();

        return redirect('login');
    }

    public function login(Request $request)
    {
        $data = $this->userService->login($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    public function appLogout(Request $request)
    {
        $data = $this->userService->appLogout($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }
}
