<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\AgentService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use Session;

class AgentMappingController extends Controller
{

    public $agentService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(AgentService $agentService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->agentService = $agentService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->agentService->getMappingData();
            $args->active = false;
            $args->inactive = false;
            $args->view = false;
            $args->wrapTxt = true;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;
        return view('master.agent.mapping-list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->agentService->saveMappingData($request)) {
            Session::flash('success', 'Agent Mapping successfull');
        } else {
            Session::flash('danger', 'Agent Mapping failed');
        }
        return redirect()->route('agent-mapping.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->agentService->isNewMapping($id);
        return view('master.agent.mapping-form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->agentService->saveMappingData($request, $id)) {
            Session::flash('success', 'Agent Mapping updated successfully');
        } else {
            Session::flash('danger', 'Agent Mapping updated failed');
        }
        return redirect()->route('agent-mapping.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
