<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\AgentService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Session;

class AgentMasterController extends Controller
{

    public $agentService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(AgentService $agentService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->agentService = $agentService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->agentService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('master.agent.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->agentService->saveData($request)) {
            Session::flash('success', 'Agent created successfully');
        } else {
            Session::flash('danger', 'Agent creation failed');
        }
        return redirect()->route('agent-master.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->agentService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('agent-master.index');
        $data->breadcrumbTitle = 'Agent';
        // $data->attchmentList = [];
        // if($data->attachments){
        //     $data->attchmentList = explode(',', $data->attachments);
        // }
        return view('master.agent.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->agentService->isNew($id);
        return view('master.agent.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->agentService->saveData($request, $id)) {
            Session::flash('success', 'Agent updated successfully');
        } else {
            Session::flash('danger', 'Agent updated failed');
        }
        return redirect()->route('agent-master.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    function getAgentsList(Request $request) {
        $data = $this->agentService->getAgentsList($request);
        return response()->json($data);
    }
}
