<?php

namespace App\Http\Controllers\Masters;

use App\Services\DataTableService;
use App\Services\Master\BlockMasterService;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Session;
use App\Http\Controllers\Controller;
use App\Services\Master\PrivilegeService;

class BlockMasterController extends Controller
{

    public $blockMasterService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(BlockMasterService $blockMasterService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->blockMasterService = $blockMasterService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->blockMasterService->getBlockData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('master.block.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->blockMasterService->saveData($request)) {
            Session::flash('success', 'Block created successfully');
        } else {
            Session::flash('danger', 'Block creation failed');
        }
        return redirect()->route('block.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id=null)
    {
        $data = $this->blockMasterService->isNew($id);
        
        return view('master.block.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->blockMasterService->saveData($request, $id)) {
            Session::flash('success', 'Block updated successfully');
        } else {
            Session::flash('danger', 'Block updated failed');
        }
        return redirect()->route('block.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
