<?php

namespace App\Http\Controllers\Masters;

use App\Services\DataTableService;
use Illuminate\Http\Request;
use Session;
use App\Http\Controllers\Controller;
use App\Services\CampaignService;
use App\Services\Master\PrivilegeService;

class CampaignController extends Controller
{

    public $campaignService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(CampaignService $campaignService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->campaignService = $campaignService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->campaignService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('master.campaign.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->campaignService->saveData($request)) {
            Session::flash('success', 'Campaign created successfully');
        } else {
            Session::flash('danger', 'Campaign creation failed');
        }
        return redirect()->route('campaign.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->campaignService->show($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('campaign.index');
        $data->breadcrumbTitle = 'Campaign';
        return view('master.campaign.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->campaignService->isNew($id);
        return view('master.campaign.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->campaignService->saveData($request, $id)) {
            Session::flash('success', 'Campaign updated successfully');
        } else {
            Session::flash('danger', 'Campaign updated failed');
        }
        return redirect()->route('campaign.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    function getCampaign(Request $request)
    {
        $data = $this->campaignService->getCampaign($request);
        return response()->json($data);
    }
}
