<?php

namespace App\Http\Controllers\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Support\Collection;
use App\Services\Master\PrivilegeService;
use Session;
use App\Utilities\AppClass;

class PrivilegesController extends Controller
{

    public $privilegeService;
    public $dataTableService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        $args->active = false;
        $args->inactive = false;
        if ($request->ajax()) {
            $data = $this->privilegeService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('master.privileges.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->privilegeService->saveData($request)) {
            Session::flash('success', 'Privilege created successfully');
        } else {
            Session::flash('danger', 'Privilege created failed');
        }
        return redirect()->route('privileges.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = new AppClass();
        $data->list = $this->privilegeService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('privileges.index');
        $data->breadcrumbTitle = 'Privileges';
        return view('master.privileges.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->privilegeService->isNew($id);
        return view('master.privileges.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->privilegeService->saveData($request)) {
            Session::flash('success', 'Privilege updated successfully');
        } else {
            Session::flash('danger', 'Privilege updated failed');
        }
        return redirect()->route('privileges.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
