<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\AnalyticsDashboardService;

class AnalyticsDashboard extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $analyticsDashboardService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, AnalyticsDashboardService $analyticsDashboardService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->analyticsDashboardService = $analyticsDashboardService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = $this->privilegeService->getPrivilegeDetails();
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.analytics-dashboard', compact('data'));
    }

    public function getDashboardData(Request $request)
    {
        return $this->analyticsDashboardService->getDashboardData($request);
    }

}
