<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\BranchSummaryService;

class BranchSummaryController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $branchSummaryService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, BranchSummaryService $branchSummaryService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->branchSummaryService = $branchSummaryService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = $this->privilegeService->getPrivilegeDetails();
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.branch-summary', compact('data'));
    }

    function getBranchData(Request $request)
    {
        $result = $this->branchSummaryService->getData($request);
        $html = view('reports.branch-summary-table', compact('result'))->render();
        return response()->json(['html' => $html]);
    }
}
