<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\CallLogsService;

class CallLogsReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $callLogsService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, CallLogsService $callLogsService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->callLogsService = $callLogsService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
    
        if ($request->ajax()) {
            $data = $this->callLogsService->getData($request, 'caller');
            $args->showrecordings = true;
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        return view('reports.call-logs-report', compact('data'));
    }
}
