<?php

namespace App\Http\Controllers\Reports;

use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Reports\EscalationDashboardService;

class EscalationDashboardController extends Controller
{

    public $escalationDashboardService;
    public $privilegeService;
    public $dataTableService;

    public function __construct(EscalationDashboardService $escalationDashboardService, PrivilegeService $privilegeService, DataTableService $dataTableService)
    {
        $this->escalationDashboardService = $escalationDashboardService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    public function index(Request $request)
    {
        $data = $this->escalationDashboardService->getEscalationDashboard($request);
        return view($data->view, compact('data'));
    }

    public function getDashboardData(Request $request)
    {
        return $this->escalationDashboardService->getDashboardData($request);
    }

}
