<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\NocallNologinService;

class NocallNologinReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $nocallNologinService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, NocallNologinService $nocallNologinService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->nocallNologinService = $nocallNologinService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->nocallNologinService->getData($request);
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.nocall-nologin', compact('data'));
    }
}
