<?php

namespace App\Http\Controllers\Reports;


use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Reports\PresentationReportService;

class PresentationReportController extends Controller
{

    public $presentationReportService;
    public $privilegeService;
    public $dataTableService;

    public function __construct(PresentationReportService $presentationReportService, PrivilegeService $privilegeService, DataTableService $dataTableService)
    {
        $this->presentationReportService = $presentationReportService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    public function index(Request $request)
    {
        $data = $this->presentationReportService->getEscalationDashboard($request);
        return view($data->view, compact('data'));
    }

    public function getDashboardData(Request $request)
    {
        return $this->presentationReportService->getDashboardData($request);
    }

    public function handleAjax(Request $request)
    {
        $type = $request->type;
        switch ($type) {
            case 'total-calls':
                return $this->presentationReportService->getTotalCallsSummary($request);
                break;
            case 'program-wise-calls':
                return $this->presentationReportService->getProgramwiseCalls($request);
                break;
            case 'programwise-chart':
                return $this->presentationReportService->getProgramwiseChart($request);
                break;
            case 'programwise-chart-percentage':
                return $this->presentationReportService->getProgramwiseChartPercentage($request);
                break;
            case 'separate-program-wise-calls':
                return $this->presentationReportService->getSeparateProgramwiseCalls($request);
                break;
            case 'districtwise-chart':
                return $this->presentationReportService->getDistrictwiseChart($request);
                break;
            case 'maximum-feedback-chart':
                return $this->presentationReportService->getMaximumFeedbackChart($request);
                break;
            case 'maximum-feedback-chart-percentage':
                return $this->presentationReportService->getMaximumFeedbackChartPercentage($request);
                break;
            case 'maximum-complaints-chart':
                return $this->presentationReportService->getMaximumComplaintsChart($request);
                break;
            case 'maximum-complaints-chart-percentage':
                return $this->presentationReportService->getMaximumComplaintsChartPercentage($request);
                break;
            case 'high-complaints-program-wise':
                return $this->presentationReportService->highComplaintsProgramwise($request);
                break;
            case 'high-complaints-district-wise-data':
                return $this->presentationReportService->highComplaintsDistrictwiseData($request);
                break;
            case 'categorywise-complaints':
                return $this->presentationReportService->categorywiseComplaints($request);
                break;
            case 'top-complaints-districts':
                return $this->presentationReportService->topComplaintsDistricts($request);
                break;
            case 'top-complaints-districts-percentage':
                return $this->presentationReportService->topComplaintsDistrictsPercentage($request);
                break;
            case 'max-wrong-numbers':
                return $this->presentationReportService->maxWrongNumbersChart($request);
                break;
            case 'max-wrong-numbers-percentage':
                return $this->presentationReportService->maxWrongNumbersChartPercentage($request);
                break;
            case 'not-attend':
                return $this->presentationReportService->notAttendChart($request);
                break;
            case 'not-attend-percentage':
                return $this->presentationReportService->notAttendChartPercentage($request);
                break;
            case 'resolved-charts':
                return $this->presentationReportService->resolvedChart($request);
                break;
            case 'resolved-charts-percentage':
                return $this->presentationReportService->resolvedChartPercentage($request);
                break;
            case 'resolved-table':
                $data = $this->presentationReportService->getResolvedFeedbacks($request);
                return response()->json($data);
                break;
            case 'reconnected-charts':
                return $this->presentationReportService->getReconnectedChart($request);
                break;
            case 'reconnected-charts-percentage':
                return $this->presentationReportService->getReconnectedChartPercentage($request);
                break;
            case 'reconnected-table':
                $data = $this->presentationReportService->reconnectData($request);
                return response()->json($data);
                break;
            case 'complaints-comparision':
                return $this->presentationReportService->complaintsComparision($request);
                break;
            case 'complaints-table':
                return $this->presentationReportService->complaintsComparisionTable($request);
                break;
            case 'feedback-comparision':
                return $this->presentationReportService->feedbackComparision($request);
                break;
            case 'feedback-table':
                return $this->presentationReportService->feedbackComparisionTable($request);
                break;
            case 'esc-dashboard-counts':
                return $this->presentationReportService->getEscDashboardCounts($request);
                break;
            case 'complaints-resolved-by-worker':
                return $this->presentationReportService->complaintsResolvedByWorker($request);
                break;
            case 'districtwise-avg-time-resolved':
                return $this->presentationReportService->districtwiseAvgTimeResolved($request);
                break;
            case 'answered-comparision-chart':
                return $this->presentationReportService->answeredComparisionChart($request);
                break;
        }
    }
}
