<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\Reports\AgentwiseCallsService;
use App\Services\Reports\CallLogsService;
use App\Services\Reports\CallsDialledService;
use App\Services\CRM\Masters\TicketsService;
use App\Services\Reports\ConnectedConvertedReportService;
use App\Services\Reports\CRMReportService;
use App\Services\Reports\EnquiryReportService;
use App\Services\Reports\JustDialReportService;
use App\Services\Reports\NocallAgentsService;
use App\Services\Reports\NocallNologinService;
use App\Services\Reports\NoLoginNoCallService;
use App\Services\Reports\ReferralReportService;
use App\Services\Reports\SalesAnalysisReportService;
use App\Services\Reports\SalesReportService;
use App\Services\Reports\VendorCampaignReportService;
use App\Services\Transactions\CallMappingService;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public $callLogsService;
    public $callsDialledService;
    public $ticketsService;
    public $justDialReportService;
    public $callMappingService;
    public $cRMReportService;
    public $salesReportService;
    public $enquiryReportService;
    public $connectedConvertedReportService;
    public $noLoginNoCallService;
    public $nocallAgentsService;
    public $agentwiseCallsService;
    public $nocallNologinService;
    public $referralReportService;
    public $salesAnalysisReportService;
    public $vendorCampaignReportService;

    public function __construct(CallLogsService $callLogsService, CallsDialledService $callsDialledService, TicketsService $ticketsService, JustDialReportService $justDialReportService, CallMappingService $callMappingService, CRMReportService $cRMReportService, SalesReportService $salesReportService, EnquiryReportService $enquiryReportService, ConnectedConvertedReportService $connectedConvertedReportService, NoLoginNoCallService $noLoginNoCallService, NocallAgentsService $nocallAgentsService, AgentwiseCallsService $agentwiseCallsService, NocallNologinService $nocallNologinService, ReferralReportService $referralReportService, SalesAnalysisReportService $salesAnalysisReportService, VendorCampaignReportService $vendorCampaignReportService)
    {
        $this->callLogsService = $callLogsService;
        $this->callsDialledService = $callsDialledService;
        $this->ticketsService = $ticketsService;
        $this->justDialReportService = $justDialReportService;
        $this->callMappingService = $callMappingService;
        $this->cRMReportService = $cRMReportService;
        $this->salesReportService = $salesReportService;
        $this->enquiryReportService = $enquiryReportService;
        $this->connectedConvertedReportService = $connectedConvertedReportService;
        $this->noLoginNoCallService = $noLoginNoCallService;
        $this->nocallAgentsService = $nocallAgentsService;
        $this->agentwiseCallsService = $agentwiseCallsService;
        $this->nocallNologinService = $nocallNologinService;
        $this->referralReportService = $referralReportService;
        $this->salesAnalysisReportService = $salesAnalysisReportService;
        $this->vendorCampaignReportService = $vendorCampaignReportService;
    }

    public function navigateToReport(Request $request)
    {
        $type = $request->has('type') ? $request->get('type') : null;
        switch ($type) {
            case 'call-logs-report':
                return $this->getCallLogsReport($request);
                break;
            case 'calldialled-report-excel':
                return $this->getCallsDialledReportExcel($request);
                break;
            case 'tickets-report-excel':
                return $this->getTicketsReportExcel($request);
                break;
            case 'justdial-report-excel':
                return $this->getJustDialReportExcel($request);
                break;
            case 'crm-report-excel':
                return $this->getCRMReportExcel($request);
                break;
            case 'enquiry-report-excel':
                return $this->getEnquiryReportExcel($request);
                break;
            case 'sales-report-excel':
                return $this->getSalesReportExcel($request);
                break;
            case 'connected-report-excel':
                return $this->getConnectedReportExcel($request);
                break;
            case 'nologin-nocalls-report-excel':
                return $this->noLoginNoCallService->getReportExcel($request);
                break;
            case 'nocalls-report-excel':
                return $this->nocallAgentsService->getReportExcel($request);
                break;
            case 'agentwise-calls-report-excel':
                return $this->agentwiseCallsService->getReportExcel($request);
                break;
            case 'nocalls-nologin-report-excel':
                return $this->nocallNologinService->getReportExcel($request);
                break;
            case 'referral-report-excel':
                return $this->referralReportService->getReportExcel($request);
                break;
            case 'sales-analysis-report-excel':
                return $this->salesAnalysisReportService->getReportExcel($request);
                break;
            case 'vendor-campaign-excel':
                return $this->vendorCampaignReportService->getReportExcel($request);
                break;
        }
    }

    public function getCallLogsReport(Request $request)
    {
        return $this->callLogsService->getCallLogsReport($request);
    }

    public function getCallsDialledReportExcel(Request $request)
    {
        return $this->callsDialledService->getCallsDialledReportExcel($request);
    }
    public function getTicketsReportExcel(Request $request)
    {
        return $this->ticketsService->getTicketsReportExcel($request);
    }
    public function getJustDialReportExcel(Request $request)
    {
        return $this->justDialReportService->getJustDialReportExcel($request);
    }

    public function getCRMReportExcel(Request $request)
    {
        return $this->cRMReportService->getCRMReportExcel($request);
    }
    public function getSalesReportExcel(Request $request)
    {
        return $this->salesReportService->getSalesReportExcel($request);
    }
    public function getConnectedReportExcel(Request $request)
    {
        return $this->connectedConvertedReportService->getConnectedReportExcel($request);
    }
    public function getEnquiryReportExcel(Request $request)
    {
        return $this->enquiryReportService->getEnquiryReportExcel($request);
    }

    function exportExcelById(Request $request, $id = null, $name = null)
    {
        $id = $id ? decrypt($id) : null;
        switch ($name) {
            case 'call-mapping':
                return $this->callMappingService->exportExcel($id);
                break;
        }
    }
}
