<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\SalesAnalysisReportService;

class SalesAnalysisReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $salesAnalysisReportService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, SalesAnalysisReportService $salesAnalysisReportService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->salesAnalysisReportService = $salesAnalysisReportService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = $this->privilegeService->getPrivilegeDetails();
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.sales-analysis', compact('data'));
    }

    function getSalesAnalysisData(Request $request)
    {
        $result = $this->salesAnalysisReportService->getData($request);
        $html = view('reports.sales-analysis-table', compact('result'))->render();
        return response()->json(['html' => $html]);
    }
}
