<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\SalientSummaryService;

class SalientSummaryController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $salientSummaryService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, SalientSummaryService $salientSummaryService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->salientSummaryService = $salientSummaryService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = $this->privilegeService->getPrivilegeDetails();
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.sailient-summary', compact('data'));
    }

    function getSailientData(Request $request)
    {
        $result = $this->salientSummaryService->getData($request);
        // dd($result);
        $html = view('reports.sailient-summary-table', compact('result'))->render();
        return response()->json(['html' => $html]);
    }
}
