<?php

namespace App\Http\Controllers;

use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\Master\SectorService;
use Illuminate\Http\Request;
use Session;

class SectorController extends Controller
{

    public $sectorService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(SectorService $sectorService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->sectorService = $sectorService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->sectorService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('master.sector.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->sectorService->saveData($request)) {
            Session::flash('success', 'Sector created successfully');
        } else {
            Session::flash('danger', 'Sector creation failed');
        }
        return redirect()->route('sector-master.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->sectorService->isNew($id);
        return view('master.sector.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->sectorService->saveData($request, $id)) {
            Session::flash('success', 'Sector updated successfully');
        } else {
            Session::flash('danger', 'Sector updated failed');
        }
        return redirect()->route('sector-master.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
