<?php

namespace App\Http\Controllers\Transactions;

use App\Http\Controllers\Controller;
use App\Imports\CallCenterImport;
use App\Services\DataTableService;
use App\Services\FeedbackService;
use App\Services\Master\PrivilegeService;
use App\Services\Transactions\CallCenterService;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Facades\Excel;
use Session;

class CallCenterController extends Controller
{

    public $callCenterService;
    public $dataTableService;
    public $privilegeService;
    public $feedbackService;

    public function __construct(CallCenterService $callCenterService, DataTableService $dataTableService, PrivilegeService $privilegeService, FeedbackService $feedbackService)
    {
        $this->callCenterService = $callCenterService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
        $this->feedbackService = $feedbackService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->callCenterService->getData($request, 'caller');
            $args->dropDownDesign = false;
            $args->createRouteName = 'feedback.createNew';
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->createBreadcrumbName = 'Manual Call';
        $data->importBreadcrumbAction = route('caller.getImport');
        $data->action = route('navigateReport');
        $data->method = 'POST';
        $data->pendingCallsExcel = true;
        $data->sampleTemplateBreadcrumbAction = route('downloadAttachments', ['type' => 'sample_beneficiay_import', 'file' => 'customers.csv']);

        return view('transactions.callers.list', compact('data'));
    }

    public function callbackList(Request $request)
    {
        if ($request->ajax()) {
            $args = $this->privilegeService->getPrivilegeDetails();
            $data = $this->callCenterService->getCallbackList($request);
            $args->dropDownDesign = false;
            $args->createRouteName = 'feedback.createNew';
            return $this->dataTableService->getDataTable($data, $args);
        }
    }

    public function callAnotherNumberList(Request $request)
    {
        if ($request->ajax()) {
            $args = $this->privilegeService->getPrivilegeDetails();
            $data = $this->callCenterService->getCallAnotherList($request);
            $args->dropDownDesign = false;
            $args->createRouteName = 'feedback.createNew';
            return $this->dataTableService->getDataTable($data, $args);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data = $this->feedbackService->isNew();
        return view('feedback.form', compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getImportPage()
    {
        $data = new Collection();
        $data->breadcrumbName = 'Import';
        $data->breadcrumbAction = route('caller.index');
        $data->createBreadcrumbName = 'Create';
        $data->breadcrumbTitle = 'Auto - Dialer / Import';
        $data->route = route('caller.import-beneficiary');
        $data->method = 'POST';
        return view('transactions.callers.import-index', compact('data'));
    }

    public function import()
    {
        $data = new Collection();
        $data->breadcrumbName = 'Import';
        $data->breadcrumbAction = route('caller.index');
        $data->createBreadcrumbName = 'Import';
        $data->breadcrumbTitle = 'Import';

        $obj = new CallCenterImport();
        Excel::import($obj, request()->file('attachments'));
        $data->rows = $obj->rows;
        if (count($data->rows) > 10000) {
            Session::flash('danger', 'upload below 10000 records at the time of import');
            return redirect()->route('caller.index');
        }
        $data->headers = $this->callCenterService->getDBColumnsImport();
        $data->columnCount = count($data->rows[0]);
        $data->route = route('caller.saveImport');
        $data->method = 'POST';
        return view('transactions.callers.import-view', compact('data'));
    }

    public function saveImport(Request $request)
    {
        $data = new Collection();
        $data->breadcrumbName = 'Import';
        $data->breadcrumbAction = route('caller.index');
        $data->createBreadcrumbName = 'Import';
        $data->breadcrumbTitle = 'Import';
        $data->backToLink = route('caller.index');
        $data->response = $this->callCenterService->saveImportData($request);

        if ($data->response->status) {
            Session::flash('success', 'Imported successfully');
            return redirect()->route('caller.index');
        } else {
            Session::flash('danger', 'Import Failed');
            return redirect()->route('caller.index');
        }

        return view('templates.import-response', compact('data'));
    }

    public function getMasterFeedbackForm(Request $request)
    {
        $data = $this->feedbackService->getMasterFeedbackForm($request);
        $response = [
            'status' => true,
            'html' => $data->html,
            'feedback_master_id' => $data->id,
        ];
        return response()->json($response);
    }

    public function initCall(Request $request)
    {
        $response = $this->callCenterService->initCall($request);
        return response()->json($response);
    }

    public function makeCall(Request $request)
    {
        $response = $this->callCenterService->makeCall($request);
        return response()->json($response);
    }

    public function updateCallStatus(Request $request)
    {
        if ($this->callCenterService->updateCallStatus($request)) {
            Session::flash('success', 'Updated successfully');
        } else {
            Session::flash('danger', 'Update failed');
        }
        return redirect()->route('caller.index');
    }

    public function getDialerList(Request $request)
    {
        $data = $this->callCenterService->getDialerList($request);
        return $data;
    }

    public function getDialerCounts(Request $request)
    {
        $data = $this->callCenterService->getDialerCounts($request, 'app-dialer');
        return $data;
    }

    public function getCallSkipReasons(Request $request)
    {
        $data = $this->callCenterService->getCallSkipReasons($request);
        return $data;
    }

    public function updateCallSkipReasons(Request $request)
    {
        $data = $this->callCenterService->updateCallSkipReasons($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    public function makeCallApp(Request $request)
    {
        $data = $this->callCenterService->makeCallApp($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    public function saveRecordings(Request $request)
    {
        $data = $this->callCenterService->saveRecordings($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    public function saveCallLogs(Request $request)
    {
        $data = $this->callCenterService->saveCallLogs($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    public function updateLeadStatus(Request $request)
    {
        $data = $this->callCenterService->updateLeadStatus($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }

    function downloadPendingCalls(Request $request)
    {
        return $this->callCenterService->downloadPendingCalls();
    }
}
