<?php

namespace App\Imports;

use App\Models\CustomerCoupons;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class CouponImport implements ToCollection
{

    public $rows;

    public function __construct() {}

    public function collection(Collection $collection)
    {

        $this->rows = $collection;

        if (count($this->rows) > 0) {
            $this->processData();
        }
    }

    public function processData()
    {
        $rows = $this->rows;
        if ($rows) {
            foreach ($rows as $key => $row) {
                if ($key > 0) {
                    $coupon = new CustomerCoupons();
                    $coupon->coupon_code = trim($row[0]);
                    $coupon->coupon_amount = trim($row[2]);
                    $coupon->save();
                }
            }
        }
    }
}
