<?php

namespace App\Imports;

use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Models\Masters\ClassMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\RoleMaster;
use App\Models\User;
use App\Models\CRM\Masters\CrmBrands;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use DB;

class CreateCrmBrands implements ToCollection
{

    public $rows;

    public function __construct() {}

    public function collection(Collection $collection)
    {

        try {
            DB::beginTransaction();
            $this->rows = $collection;
            if (count($this->rows) > 0) {
                $this->processData();
            }
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e->getMessage());
        }
    }

    public function processData()
    {
        $rows = $this->rows;
        foreach ($rows as $key => $row) {
            if ($key == 0) continue; // skip header row

            $value = isset($row[0]) ? trim($row[0]) : null;

            if (!empty($value)) {
                $exists = CrmBrands::where('name', $value)->count();

                if ($exists == 0) {
                    $crmBrands = new CrmBrands();
                    $crmBrands->name = $value;
                    $crmBrands->description = $value;
                    $crmBrands->save();
                }
            }
        }
    }
}
