<?php

namespace App\Imports;

use App\Models\Masters\CityMaster;
use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Utilities\AppClass;
use Illuminate\Support\Collection;
use Log;
use Maatwebsite\Excel\Concerns\ToCollection;

class EscalationLevelThreeImportNew implements ToCollection
{
    public $rows;

    public function __construct()
    {
    }

    public function collection(Collection $collection)
    {

        $this->rows = $collection;
        if (count($this->rows) > 0) {
            $this->processData();
        }
    }

    public function processData()
    {
        $rows = $this->rows;
        $rows = $this->removeNullValues($rows);

        if ($rows) {
            foreach ($rows as $levelOfficer) {
                $escalationMatrix = $this->getMatrixs($levelOfficer);
                if ($escalationMatrix) {
                    foreach ($escalationMatrix as $matrixRow) {
                        $levels = new EscalationMatrixLevels();
                        $levels->escalation_reference_id = $matrixRow->id;
                        $levels->name = $levelOfficer->name;
                        $levels->level = 3;
                        $levels->mobile = $levelOfficer->mobile;
                        $levels->district = $levelOfficer->districtName;
                        $levels->days = 30;
                        $levels->save();
                    }
                }
            }
        }
    }

    public function getMatrixs($levelOfficer)
    {
        $data = EscalationMatrix::where('district_id', $levelOfficer->districtId)->get();
        return $data;
    }

    public function removeNullValues($rows)
    {
        $data = new Collection();
        foreach ($rows as $key => $user) {
            if ($key > 0) {

                $mobile = str_replace(' ', '', $user[3]);

                $districtId = $this->getDistrictId($user[1]);
                if (!$districtId) {
                    dd($user);
                }
                $new = new AppClass();
                $new->name = trim($user[2]);
                $new->mobile = trim($mobile);
                $new->districtId = $districtId;
                $new->districtName = $user[0];
                $data->add($new);
            }
        }
        return $data;
    }

    public function getDistrictId($code)
    {
        $districtDet = CityMaster::where('code', trim($code))->first();
        if ($districtDet) {
            return $districtDet->id;
        }
    }
}
