<?php

namespace App\Imports;

use App\Models\Masters\BlockMaster;
use App\Models\Masters\CityMaster;
use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Utilities\AppClass;
use Illuminate\Support\Collection;
use Log;
use Maatwebsite\Excel\Concerns\ToCollection;

class EscalationLevelTwoImportNew implements ToCollection
{
    public $rows;

    public function __construct()
    {
    }

    public function collection(Collection $collection)
    {
        $this->rows = $collection;
        if (count($this->rows) > 0) {
            $this->processData();
        }
    }

    public function processData()
    {
        $rows = $this->rows;
        $rows = $this->removeNullValues($rows);
        dd($rows);
        if ($rows) {
            foreach ($rows as $levelOfficer) {
                $escalationMatrix = $this->getMatrixs($levelOfficer);
                if ($escalationMatrix) {
                    foreach ($escalationMatrix as $matrixRow) {
                        $levels = new EscalationMatrixLevels();
                        $levels->escalation_reference_id = $matrixRow->id;
                        $levels->name = $levelOfficer->name;
                        $levels->level = 2;
                        $levels->mobile = $levelOfficer->mobile;
                        $levels->district = $levelOfficer->districtName;
                        $levels->days = 15;
                        $levels->save();
                    }
                }
            }
        }
    }

    public function getMatrixs($levelOfficer)
    {
        $data = EscalationMatrix::where('block_id', $levelOfficer->blockId)->get();
        return $data;
    }

    public function removeNullValues($rows)
    {
        $data = new Collection();
        foreach ($rows as $key => $user) {
            if ($key > 0) {

                $mobile = str_replace(' ', '', $user[2]);

                $block = $this->getBlockId(trim($user[0]));
                if ($block) {
                    $new = new AppClass();
                    $new->name = trim($user[1]);
                    $new->mobile = trim($mobile);
                    $new->blockId = $block->id;
                    $new->districtName = $block->name;
                    $data->add($new);
                } else {
                    Log::info('block not found : ' . $user[0]);
                }
            }
        }
        return $data;
    }

    public function getBlockId($code)
    {
        $blockDet = DB::table('block_master')
            ->join('city_master', 'city_master.id', 'block_master.district_id')
            ->select('block_master.id', 'city_master.name')
            ->where('block_master.code', trim($code))->first();
        return $blockDet;
    }
}
