<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Feedback extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'feedback';
    protected $primaryKey = 'id';

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    const RESOLVED_STATUS_PENDING = 0;
    const RESOLVED_STATUS_RESOLVED = 1;

    const IS_COMPLIANT = 1;

    CONST DEFAULT_COMPLAINT_LEVEL = 1;

    const CALL_MISS_REASONS = [
        1 => 'Wrong Number',
        2 => 'Master Data Correction',
    ];

}
