<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\CrmBrands;
use Illuminate\Http\Request;
use Auth;

class CrmBrandsService
{

    public function __construct() {}

    public function getData()
    {
        $sql = CrmBrands::orderBy('id', 'desc');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = CrmBrands::find($id);
            $data->route = route('crm-brand.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new CrmBrands();
            $data->route = route('crm-brand.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('crm-brand.index');
        $data->breadcrumbTitle = 'CRM Brands';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $description = $request->has('description') ? $request->get('description') : '';

        if ($id) {
            $data = CrmBrands::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new CrmBrands();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->description = $description;
        if ($data->save()) {
            return true;
        }
    }

}
