<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\CrmProducts;
use Illuminate\Http\Request;
use Auth;

class ProductService
{

    public function __construct() {}

    public function getData()
    {
        $sql = CrmProducts::select(
            'crm_products.*', // Select all columns from crm_products
            'crm_brands.name as brand_name' // Select the brand name from crm_brands
        )
        ->leftJoin('crm_brands', 'crm_products.brand', '=', 'crm_brands.id') // Join with crm_brands table
        ->orderBy('crm_products.id', 'desc');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = CrmProducts::find($id);
            $data->route = route('crm-product.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new CrmProducts();
            $data->route = route('crm-product.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('crm-product.index');
        $data->breadcrumbTitle = 'Products';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $amount = $request->has('amount') ? $request->get('amount') : '';
        $brand = $request->has('brand') ? $request->get('brand') : '';
        $description = $request->has('description') ? $request->get('description') : '';

        if ($id) {
            $data = CrmProducts::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new CrmProducts();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->code = $code;
        $data->amount = $amount;
        $data->brand = $brand;
        $data->description = $description;
        if ($data->save()) {
            return true;
        }
    }

    public function showData($id)
    {
        return CrmProducts::find($id);
    }
}
