<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\TicketCategory;
use Illuminate\Http\Request;
use Auth;

class TicketCategoryService
{

    public function __construct() {}

    public function getData()
    {
        $sql = TicketCategory::orderBy('id', 'desc');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = TicketCategory::find($id);
            $data->route = route('ticket-category.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new TicketCategory();
            $data->route = route('ticket-category.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('ticket-category.index');
        $data->breadcrumbTitle = 'Ticket Category';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $description = $request->has('description') ? $request->get('description') : '';

        if ($id) {
            $data = TicketCategory::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new TicketCategory();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->description = $description;
        if ($data->save()) {
            return true;
        }
    }

}
