<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\CrmProducts;
use App\Models\CRM\Masters\SubDepartments;
use App\Models\CRMTickets;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\TicketsCloseReason;
use App\Models\Masters\TicketStatus;
use App\Models\Masters\UserMaster;
use App\Models\NumberingSystem;
use App\Models\Sales;
use App\Models\Transactions\BeneficiaryImport;
use App\Services\CommonService;
use App\Services\CRMTicketService;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use Auth;
use Carbon\Carbon;
use stdClass;
use DB;
use Illuminate\Support\Facades\Session;

class TicketsService
{
    private $cRMTicketService;
    private $reportService;
    private $commonService;
    public $excelExportService;

    public function __construct(CRMTicketService $cRMTicketService, ReportService $reportService, CommonService $commonService, ExcelExportService $excelExportService)
    {
        $this->cRMTicketService = $cRMTicketService;
        $this->reportService = $reportService;
        $this->commonService = $commonService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $sql = CRMTickets::select(
            'crm_tickets.mobile',
            'crm_tickets.customer_name',
            'crm_tickets.secondary_mobile',
            'crm_tickets.email',
            'crm_tickets.expected_price',
            'crm_tickets.offer_price',
            'crm_tickets.location',
            'crm_tickets.address',
            'crm_tickets.lead_status',
            'crm_tickets.ticket_comment as wrapText',
            'ticket_category.name as ticketCategory',
            'users.name as createdUser',
            // 'branch_master.name as branchName',
            'crm_products.name as productName',
            'crm_brands.name as barndName',
            'sub_departments.name as deptName',
            'ticket_source.name as sourceName',
            'ticket_type.name as typeName',
            'priority_type.name as priorityName',
            'agent_master.name as assignedUser',
            'class_master.name as agentClass',
            'designation_master.name as agentDesignation',
            'crm_tickets.id',
            'crm_tickets.ticket_no',
            'crm_tickets.status',
            // 'tickets_close_reason.name as reason',
            DB::raw('DATE_FORMAT(crm_tickets.created_at, "%d-%m-%Y %h:%i %p") as formattedCreatedAt'),
            DB::raw('CONCAT("' . url(CRMTickets::FILE_PATH) . '/", crm_tickets.attachments) as downloadUrl'),
            DB::raw('DATE_FORMAT(crm_tickets.expected_date, "%d-%m-%Y") as expectedDate'),
            DB::raw('
            CASE 
                WHEN crm_tickets.read_status = 1 THEN "Seen"
                WHEN crm_tickets.read_status = 2 THEN "Called"
                ELSE "Pending"
            END as readStatus
        '),
            'branch_master.name as branchName'
        )
            ->leftJoin('branch_master', 'branch_master.id', 'crm_tickets.branch_id')
            ->leftJoin('users', 'users.id', 'crm_tickets.created_by')
            ->leftJoin('crm_products', 'crm_products.id', 'crm_tickets.product_enquiry')
            ->leftJoin('sub_departments', 'sub_departments.id', 'crm_tickets.department')
            ->leftJoin('ticket_source', 'ticket_source.id', 'crm_tickets.ticket_source')
            ->leftJoin('ticket_type', 'ticket_type.id', 'crm_tickets.ticket_type')
            ->leftJoin('priority_type', 'priority_type.id', 'crm_tickets.priority')
            ->leftJoin('agent_master', 'agent_master.id', 'crm_tickets.users')
            ->leftJoin('crm_brands', 'crm_brands.id', 'crm_products.brand')
            ->leftJoin('class_master', 'class_master.id', 'agent_master.class')
            ->leftJoin('designation_master', 'designation_master.id', 'agent_master.designation')
            ->leftJoin('ticket_category', 'ticket_category.id', 'crm_tickets.ticket_category')
            // ->leftJoin('tickets_close_reason', 'tickets_close_reason.id', 'crm_tickets.reason')
            ->orderBy('crm_tickets.id', 'desc');

        if ((int)$args->status > 0) {
            $sql->where('crm_tickets.status', $args->status);
        }

        if ($args->branch) {
            $sql->where('crm_tickets.branch_id', $args->branch);
        }
        if ($args->priority) {
            $sql->where('crm_tickets.priority', $args->priority);
        }
        if ($args->source) {
            $sql->where('crm_tickets.ticket_source', $args->source);
        }
        if ($args->createdBy) {
            $sql->where('crm_tickets.created_by', $args->createdBy);
        }
        if ($args->agent) {
            $sql->where('crm_tickets.users', $args->agent);
        }
        if ($args->category) {
            $sql->where('crm_tickets.ticket_category', $args->category);
        }
        if ($args->department) {
            $sql->where('crm_tickets.department', $args->department);
        }
        if ($args->fromDate && $args->toDate) {
            $fromDate = Carbon::parse($args->fromDate)->format("Y-m-d");
            $toDate = Carbon::parse($args->toDate)->format("Y-m-d");
            $sql->where('crm_tickets.created_at', '>=', $fromDate . ' 00:00:00');
            $sql->where('crm_tickets.created_at', '<=', $toDate . ' 23:59:59');
        }
        $crmBranch = Session::get('crmBranch');
        if ($crmBranch && $crmBranch != 32) {
            $sql->where('crm_tickets.branch_id', $crmBranch);
        }
        return $sql;
    }
    function getTicketsReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'tickets-report-excel';
        return $this->excelExportService->exportExcel($params, $data);
    }
    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = CRMTickets::find($id);
            $data->route = route('tickets.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->usersList = AgentMaster::select('agent_master.id', 'agent_master.name', 'class_master.name as class', 'designation_master.name as designation')
                ->join('designation_master', 'designation_master.id', 'agent_master.designation')
                ->join('class_master', 'class_master.id', 'agent_master.class')
                ->where('agent_master.branch_id', $data->branch_id)
                ->get();
            $data->expected_date = Carbon::parse($data->expected_date)->format('m/d/Y');
        } else {
            $data = new CRMTickets();
            $data->route = route('tickets.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
            $data->usersList = [];
            $data->status_name = null;
        }
        $data->subDeptList = SubDepartments::select('id', 'name')->get();
        $data->statusList = TicketStatus::select('id', 'name')->get();
        $data->reasonList = TicketsCloseReason::select('id', 'name')->get();
        $data->breadcrumbAction = route('tickets.index');
        $data->breadcrumbTitle = 'Tickets';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        // Retrieve form inputs
        $registerMobile = $request->has('registerMobile') ? $request->get('registerMobile') : '';
        $secondaryMobile = $request->has('secondaryMobile') ? $request->get('secondaryMobile') : '';
        $customerName = $request->has('customerName') ? $request->get('customerName') : '';
        $customerEmail = $request->has('customerEmail') ? $request->get('customerEmail') : '';
        $location = $request->has('location') ? $request->get('location') : '';
        $address = $request->has('address') ? $request->get('address') : '';
        $product = $request->has('product') ? $request->get('product') : '';
        $branch = $request->has('branch') ? $request->get('branch') : '';
        $subDepartment = $request->has('subDepartment') ? $request->get('subDepartment') : null;
        $category = $request->has('category') ? $request->get('category') : '';
        $users = $request->has('users') ? $request->get('users') : '';
        $source = $request->has('source') ? $request->get('source') : '';
        $type = $request->has('type') ? $request->get('type') : '';
        $priority = $request->has('priority') ? $request->get('priority') : '';
        $expectedDate = $request->has('expectedDate') ? $request->get('expectedDate') : '';
        $expectedPrice = $request->has('expectedPrice') ? $request->get('expectedPrice') : '';
        $offerPrice = $request->has('offerPrice') ? $request->get('offerPrice') : '';
        $comments = $request->has('comments') ? $request->get('comments') : '';
        $submitType = $request->has('submitType') ? $request->get('submitType') : '';
        $reason = $request->has('close_reason') ? $request->get('close_reason') : null;
        $ticketStatus = $request->has('ticket_status') ? $request->get('ticket_status') : null;

        // Handle file upload
        $fileName = null;
        if ($request->file('attachments')) {
            $file = $request->file('attachments');
            $fileName = time() . rand(1, 99) . '.' . $file->extension();
            $file->move(public_path('uploads/crm-attachments'), $fileName);
        }

        // Load or create ticket
        if ($id) {
            $data = CRMTickets::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new CRMTickets();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
            $data->ticket_no = $this->commonService->generateUniqueScreenNumber(NumberingSystem::CRM_TICKETS);
        }

        // Format expected date
        if ($expectedDate) {
            $expectedDate = date('Y-m-d', strtotime($expectedDate));
        }

        // Determine status
        $status = CRMTickets::STATUS_ACTIVE; // Default status
        if ($submitType == 'draft') {
            $status = CRMTickets::STATUS_DRAFTS;
        } elseif ($id && $ticketStatus !== null) { // Use ticket_status for edits
            // Assuming status column is integer (based on status=0 issue)
            switch ($ticketStatus) {
                case '3': // Close
                    $status = 3;
                    break;
                case '2': // WIP
                    $status = 2;
                    break;
                case '1': // Active
                    $status = 1;
                    break;
                default:
                    $status = 1; // Fallback to Active
            }
        }

        // Update ticket fields
        $data->mobile = $registerMobile;
        $data->customer_name = $customerName;
        $data->email = $customerEmail;
        $data->location = $location;
        $data->product_enquiry = $product;
        $data->branch_id = $branch;
        $data->department = $subDepartment;
        $data->ticket_category = $category;
        $data->users = $users;
        $data->ticket_source = $source;
        $data->ticket_type = $type;
        $data->priority = $priority;
        $data->expected_date = $expectedDate;
        $data->expected_price = $expectedPrice;
        $data->offer_price = $offerPrice;
        $data->ticket_comment = $comments;
        if ($fileName) {
            $data->attachments = $fileName;
        }
        $data->secondary_mobile = $secondaryMobile;
        $data->address = $address;
        $data->reason = $reason;
        $data->status = $status; // Use calculated status

        // Save ticket
        if ($data->save()) {
            $crmId = $data->id;
            $productName = CrmProducts::find($product);

            // Update or create customer in BeneficiaryImport
            if ($id) {
                $customer = BeneficiaryImport::where('crm_lead_id', $crmId)->withTrashed()->first();
            } else {
                $customer = new BeneficiaryImport();
            }

            if ($status == CRMTickets::STATUS_DRAFTS) {
                $customer->deleted_at = Carbon::now();
            } else {
                $customer->deleted_at = null;
            }

            $customer->branch_id = $branch;
            $customer->customer_name = isset($request->customerName) ? $request->customerName : null;
            $customer->mobile_number = $registerMobile;
            $customer->description = $productName->name ?? null;
            $customer->crm_lead_id = $crmId;
            $customer->source = BeneficiaryImport::SOURCE_TYPE_CRM;
            $customer->save();

            // Send notification
            if ($branch) {
                $this->cRMTicketService->sendOnesignalCRMNotification($data);
            }

            return true;
        }

        return false;
    }

    function getSalesDetails(Request $request)
    {
        $sales = Sales::select('customer_name')->where('mobile', $request->mobile)->first();
        return $sales;
    }

    function getSubDept(Request $request)
    {
        // $dept = SubDepartments::select('id', 'name')->where('branch_id', $request->branch)->get();
        $users = AgentMaster::select('agent_master.id', 'agent_master.name', 'class_master.name as class', 'designation_master.name as designation')
            ->join('designation_master', 'designation_master.id', 'agent_master.designation')
            ->join('class_master', 'class_master.id', 'agent_master.class')
            ->where('agent_master.branch_id', $request->branch)
            ->get();
        $ret = new stdClass;
        // $ret->dept = $dept;
        $ret->users = $users;
        return $ret;
    }

    function showData($id)
    {
        $sql = CRMTickets::select(
            'crm_tickets.*',
            'ticket_category.name as ticketCategory',
            'users.name as createdUser',
            'agent_master.name as assignedUser',
            DB::raw('DATE_FORMAT(crm_tickets.created_at, "%d-%m-%Y %h:%i %p") as formattedCreatedAt'),
            DB::raw('CONCAT("' . url(CRMTickets::FILE_PATH) . '/", crm_tickets.attachments) as downloadUrl'),
            DB::raw('DATE_FORMAT(crm_tickets.expected_date, "%d-%m-%Y") as expectedDate'),
            'ticket_source.name as ticketSource',
            'ticket_type.name as ticketType',
            'priority_type.name as priorityType',
            'crm_products.name as productName',
            'request_category.name as requestCategory',
            'branch_master.name as branchName',
            'sub_departments.name as subDep',
            'ticket_close_reason.name as reason',
            'ticket_status.name as status',
        )
            ->join('branch_master', 'branch_master.id', 'crm_tickets.branch_id')
            ->join('users', 'users.id', 'crm_tickets.created_by')
            ->leftJoin('agent_master', 'agent_master.id', 'crm_tickets.users')
            ->leftJoin('ticket_category', 'ticket_category.id', 'crm_tickets.ticket_category')
            ->leftJoin('ticket_source', 'ticket_source.id', 'crm_tickets.ticket_source')
            ->leftJoin('sub_departments', 'sub_departments.id', 'crm_tickets.department')
            ->leftJoin('ticket_type', 'ticket_type.id', 'crm_tickets.ticket_type')
            ->leftJoin('priority_type', 'priority_type.id', 'crm_tickets.priority')
            ->leftJoin('crm_products', 'crm_products.id', 'crm_tickets.product_enquiry')
            ->leftJoin('request_category', 'request_category.id', 'crm_tickets.request_category')
            ->leftJoin('ticket_close_reason', 'ticket_close_reason.id', 'crm_tickets.reason')
            ->leftJoin('ticket_status', 'ticket_status.id', 'crm_tickets.status')
            ->where('crm_tickets.id', $id);
        $data = $sql->first();
        if ($data) {
            $data->subDeptList = SubDepartments::select('id', 'name')->get();
            $data->usersList = AgentMaster::select('id', 'name')->where('branch_id', $data->branch_id)->get();
        }
        return $data;
    }

    function updateTicket(Request $request)
    {
        $callType = $request->has('callType') ? $request->get('callType') : '';
        $branch = $request->has('branch') ? $request->get('branch') : '';
        $crmId = $request->has('crmId') ? $request->get('crmId') : '';
        $subDepartment = $request->has('subDepartment') ? $request->get('subDepartment') : '';
        $category = $request->has('category') ? $request->get('category') : '';
        $users = $request->has('users') ? $request->get('users') : '';
        $priority = $request->has('priority') ? $request->get('priority') : '';
        $calledFor = $request->has('calledFor') ? $request->get('calledFor') : '';
        $followupDate = $request->has('followupDate') ? $request->get('followupDate') : '';
        $talkedWith = $request->has('talkedWith') ? $request->get('talkedWith') : '';
        $ticketStatus = $request->has('ticketStatus') ? $request->get('ticketStatus') : '';
        $comments = $request->has('comments') ? $request->get('comments') : '';
        if ($followupDate) {
            $followupDate = date('Y-m-d', strtotime($followupDate));
        }
        if ($crmId) {
            $data = CRMTickets::find($crmId);
            if ($data) {
                $data->branch_id = $branch;
                $data->department = $subDepartment;
                $data->ticket_category = $category;
                $data->users = $users;
                $data->priority = $priority;
                $data->called_for = $calledFor;
                $data->follwup_date = $followupDate;
                $data->talked_with = $talkedWith;
                $data->status = $ticketStatus;
                $data->update_comments = $comments;
                $data->call_type = $callType;
                if ($data->save()) {
                    return true;
                }
            }
        }
    }

    function transferCloseLeads(Request $request)
    {
        if (count($request->leads) > 0) {
            if ($request->type == 'transfer') {
                if (CRMTickets::whereIn('id', $request->leads)->withTrashed()->update(['users' => $request->user])) {
                    if (BeneficiaryImport::whereIn('crm_lead_id', $request->leads)->withTrashed()->update(['agent_id' => $request->user])) {
                        return ['status' => 'true'];
                    }
                }
            } else if ($request->type == 'close') {
                if (CRMTickets::whereIn('id', $request->leads)->withTrashed()->update(['status' => CRMTickets::STATUS_CLOSED])) {
                    if (BeneficiaryImport::whereIn('crm_lead_id', $request->leads)->withTrashed()->update(['status' => BeneficiaryImport::STATUS_CALL_FEEDBACK_DONE])) {
                        return ['status' => 'true'];
                    }
                }
            }
        }
    }

    function getBranchUsers()
    {
        $authUser = Auth::user();
        $sql = AgentMaster::select('id', 'name');
        if ($authUser->reference_id) {
            $user = UserMaster::find($authUser->reference_id);
            if ($user) {
                $sql->where('branch_id', $user->branch_id);
            } else {
                return [];
            }
        } else {
            if (!is_null($authUser->role) && $authUser->role != 1) {
                return [];
            }
        }
        $agentMaster = $sql->get();
        return $agentMaster;
    }
}
