<?php

namespace App\Services;

use App\Models\Masters\AgentMapping;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Models\Masters\Campaign;
use Illuminate\Http\Request as HttpRequest;
use Auth;
use stdClass;
use DB;

class CampaignService
{

    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    public function getData($id = null)
    {
        $sql = Campaign::select('campaign.*')
            ->orderBy('campaign.id', 'desc');
        if ($id) {
            $sql->where('id', $id);
        }
        $data = $sql->get();
        if ($data) {
            foreach ($data as $row) {
                if ($row->branch_id != 'All') {
                    $branchId = explode(',', $row->branch_id);
                    if ($branchId) {
                        $branch = BranchMaster::select(DB::raw('GROUP_CONCAT(name) as name'))->whereIn('id', $branchId)->first();
                        $row->branch_id = $branch->name;
                    }
                }
            }
        }
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = Campaign::find($id);
            $data->route = route('campaign.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->branchId = explode(',', $data->branch_id);
        } else {
            $data = new Campaign();
            $data->route = route('campaign.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
            $data->branchId = [];
        }

        $data->breadcrumbAction = route('campaign.index');
        $data->breadcrumbTitle = 'Campaign';
        $data->branchList = BranchMaster::select('id', 'name')->whereStatus(BrandMaster::STATUS_ACTIVE)->get();
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {

        $title = $request->has('title') ? $request->get('title') : '';
        $branch = $request->has('branch') ? $request->get('branch') : '';
        $description = $request->has('description') ? $request->get('description') : '';

        $key = array_search('All', $branch);
        if ($key !== false) {
            $branchId = 'All';
        } else {
            $branchId = implode(',', $branch);
        }

        if ($id) {
            $data = Campaign::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new Campaign();
            $data->created_by = Auth::user()->id;
        }
        $data->title = $title;
        $data->branch_id = $branchId;
        $data->description = $description;
        $data->save();

        if ($data) {
            return true;
        }
    }

    function show($id)
    {
        $data = $this->getData($id);
        return $data[0];
    }

    function getCampaign($request)
    {
        $userRefId = $request->user()->reference_id;
        if ($userRefId) {
            $agent = AgentMaster::find($userRefId);
            if ($agent) {
                $sql = Campaign::select('id', 'title')
                    ->where(function ($query) use ($agent) {
                        $query->whereRaw("FIND_IN_SET(?, branch_id)", [$agent->branch_id])
                            ->orWhere('branch_id', 'All');
                    })
                    ->where('status', Campaign::STATUS_ACTIVE);

                if ($request->campaignId) {
                    $sql->where('id', $request->campaignId);
                    $sql->addSelect('description');
                    $campaign = $sql->first();
                    return $this->commonService->makeSuccessResponse('', $campaign);
                }
                $campaign = $sql->get();
                $data = new stdClass;
                $data->data = $campaign;
                return $this->commonService->makeSuccessResponse('', $data);

                return $this->commonService->makeErrorResponse('mapping not found');
            } else {
                return $this->commonService->makeErrorResponse('agent not found');
            }
        }
        return $this->commonService->makeErrorResponse('agent not found');
    }
}
