<?php

namespace App\Services;

use App\Exports\DashboardDetailedReportExport;
use App\Models\AgentsLogin;
use App\Models\EnquiryHistory;
use App\Models\Feedback;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchLeadsAssign;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\CallSkipReason;
use App\Models\Masters\ClusterMaster;
use App\Models\Masters\ClusterBranchMapping;
use App\Models\Masters\UserMaster;
use App\Models\RoleMaster;
use App\Models\Sales;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\User;
use App\Services\Transactions\CallCenterService;
use App\Utilities\AppDashboard;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use stdClass;

class DashboardService
{
    private $dashboardDetailedReportExport;
    private $excelCampaignService;
    private $callCenterService;

    public function __construct(DashboardDetailedReportExport $dashboardDetailedReportExport, ExcelCampaignService $excelCampaignService, CallCenterService $callCenterService)
    {
        $this->dashboardDetailedReportExport = $dashboardDetailedReportExport;
        $this->excelCampaignService = $excelCampaignService;
        $this->callCenterService = $callCenterService;
    }

    public function getLoggedInUserDashboard()
    {

        $data = new stdClass;

        $viewList = $this->getDashboardView();
        $data->view = $viewList->blade;
        $data->renderid = $viewList->renderid;
        $data->filters = $viewList->filters;
        $data->branch = $viewList->branch;
        $data->cluster = $viewList->cluster;
        $data->showCluster = $viewList->showCluster;
        $data->showBranch = $viewList->showBranch;
        $data->showAgent = $viewList->showAgent;
        $data->agents = $viewList->agents;
        $data->branchIds = $viewList->branchIds;
        return $data;
    }

    public function getDashboardView()
    {
        $authDetails = Auth::user();
        $role = $authDetails->role;
        $userType = $authDetails->user_type;

        $view = new stdClass;
        $view->showCluster = false;
        $view->showBranch = false;
        $view->showAgent = false;
        $view->branch = [];
        $view->branchIds = null;
        $view->cluster = [];
        $view->agents = [];
        $view->filters = true;
        $view->blade = 'dashboard';
        $view->renderid = 'dashboard-content';

        if (is_null($role) || in_array($role, RoleMaster::ADMIN_DASHBOARD_ROLES)) {
            $view->showCluster = true;
            $view->showBranch = true;
            $view->showAgent = true;
            $view->cluster = ClusterMaster::select('id', 'name')->whereStatus(ClusterMaster::STATUS_ACTIVE)->get();
        }
        // else if ($userType == User::USER_TYPE_AGENT) {
        //     $view->blade = 'dashboard';
        //     $view->renderid = 'dashboard-content';
        //     $view->filters = true;
        // } 
        else if (!in_array($role, [RoleMaster::ROLE_CLUSTER]) && $userType == User::USER_TYPE_APP_USERS) {
            $view->filters = true;
            $view->showAgent = true;
            $view->showBranch = true;
            $branch = UserMaster::select('branch_id')->where('id', $authDetails->reference_id)->first();
            if ($branch) {
                $view->branchIds = $branch->branch_id;
                $view->agents = AgentMaster::whereStatus(AgentMaster::STATUS_ACTIVE)->where('branch_id', $branch->branch_id)->get();
                $view->branch = BranchMaster::whereStatus(AgentMaster::STATUS_ACTIVE)->where('id', $branch->branch_id)->get();
            }
        } else if ($role == RoleMaster::ROLE_CLUSTER) {
            $view->showBranch = true;
            $view->showAgent = true;
            $sql = ClusterBranchMapping::select('branch_master.id', 'branch_master.name')
                ->join('branch_master', 'branch_master.id', 'cluster_branch_mapping.branch_id')
                ->where('branch_master.status', BranchMaster::STATUS_ACTIVE)
                ->where('cluster_branch_mapping.cluster_id', $authDetails->reference_id);
            $view->branch = $sql->get();
            $ids = $sql->pluck('id')->toArray();
            $view->branchIds = implode(',', $ids);
        }
        return $view;
    }

    public function processFilters(Request $request)
    {
        $branch = $request->has('branch') ? $request->get('branch') : null;
        $cluster = $request->has('cluster') ? $request->get('cluster') : null;
        $agent = $request->has('agent') ? $request->get('agent') : null;
        $dateRange = $request->has('dateRange') ? $request->get('dateRange') : null;
        $branchIds = $request->has('branchIds') ? $request->get('branchIds')  : null;
        $source = $request->has('source') ? $request->get('source')  : null;

        $dateRange = explode('-', $dateRange);
        $fromDate = str_replace('/', '-', trim($dateRange[0]));
        $toDate = str_replace('/', '-', trim($dateRange[1]));
        $fromDate = Carbon::parse($fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($toDate)->format('Y-m-d');

        $arguments = new stdClass;
        $arguments->agent = $agent;
        $arguments->branch = $branch;
        $arguments->cluster = $cluster;
        $arguments->fromDate = $fromDate;
        $arguments->toDate = $toDate;
        $arguments->source = $source;
        $arguments->branchIds = null;
        if (!is_null($branchIds) && $branchIds != '') {
            $arguments->branchIds = explode(',', $branchIds);
        }
        return $arguments;
    }

    public function newDashboardClass()
    {
        $data = new stdClass;

        $data->branchDetails = new stdClass;
        $data->branchDetails->title = 'Branch Details';
        $data->branchDetails->isTotal = true;
        $data->branchDetails->rows = new Collection();

        $data->callHistory = new stdClass;
        $data->callHistory->title = 'Calls History';
        $data->callHistory->isTotal = true;
        $data->callHistory->rows = new Collection();

        $data->answered = new stdClass;
        $data->answered->title = 'Connected Calls';
        $data->answered->isTotal = true;
        $data->answered->rows = new Collection();

        $data->unAnswered = new stdClass;
        $data->unAnswered->title = 'Not Connected Calls';
        $data->unAnswered->isTotal = true;
        $data->unAnswered->rows = new Collection();

        $data->salesMatrix = new stdClass;
        $data->salesMatrix->title = 'Sales Matrix';
        $data->salesMatrix->isTotal = false;
        $data->salesMatrix->rows = new Collection();

        return $data;
    }

    public function getAdminDashboardData(Request $request)
    {
        $data = $this->newDashboardClass();
        $arguments = $this->processFilters($request);

        $arguments->roleType = $request->roleType;
        $data = $this->getAgentCallDetails($arguments, $data);
        $args = clone $arguments;

        $html = view('agent-call-details', compact('data', 'args'))->render();

        $calls = $this->topEmployeesCalls($arguments);
        $html .= view('highest-calls-details', compact('calls'))->render();

        $return = [
            'status' => true,
            'html' => $html,
            'id' => 'dashboard-content'
        ];

        return $return;
    }

    function topEmployeesCalls($arguments)
    {
        //employee wise
        $allosql = $this->coreAgentAssignFollowDetails($arguments);
        $allosql->take(30);
        $allosqlb = clone $allosql;
        $allosql->groupBy('beneficiary_import.agent_id');
        $allosql->join('agent_master', 'agent_master.id', 'beneficiary_import.agent_id');
        $allosql->select(
            'agent_master.name as agentName',
            'agent_master.id as agentId',
            DB::raw('COUNT(beneficiary_import.id) as allocatedCalls'),
        );
        $allocatedEmp = $allosql->get();

        //branch
        $allosqlb->select(
            'branch_master.name as branchName',
            'branch_master.id as branchId',
            DB::raw('COUNT(beneficiary_import.id) as allocatedCalls'),
        );
        $allosqlb->join('branch_master', 'branch_master.id', 'beneficiary_import.branch_id');
        $allosqlb->groupBy('beneficiary_import.branch_id');
        $allocatedBranch = $allosqlb->get();

        //employee wise start
        $assignsql = $this->coreAgentCallDetails($arguments);
        $assignsql->select(
            'agent_master.name as agentName',
            'agent_master.id as agentId',
            DB::raw('COUNT(feedback.id) as dialledCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as ansCalls')
        )
            ->join('agent_master', 'agent_master.id', 'beneficiary_import.agent_id')
            ->take(30);
        $assignsqlb = clone $assignsql;
        $assignsql->groupBy('beneficiary_import.agent_id');
        $assignedEmp = $assignsql->get();

        //branch
        $assignsqlb->select(
            'branch_master.name as branchName',
            'branch_master.id as branchId',
            DB::raw('COUNT(feedback.id) as dialledCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as ansCalls')
        );
        $assignsqlb->join('branch_master', 'branch_master.id', 'beneficiary_import.branch_id');
        $assignsqlb->groupBy('beneficiary_import.branch_id');
        $assignedBranch = $assignsqlb->get();

        $data = new stdClass;
        $data->employeeWise = new Collection();
        $data->branchWise = new Collection();

        //employeewise
        foreach ($allocatedEmp as $allocatedRow) {
            foreach ($assignedEmp as $assignedRow) {
                if ($allocatedRow->agentId == $assignedRow->agentId) {
                    $node = new stdClass;
                    $node->allocatedCalls = $allocatedRow->allocatedCalls;
                    $node->dialledCalls = $assignedRow->dialledCalls;
                    $node->ansCalls = $assignedRow->ansCalls;
                    $node->agentName = $assignedRow->agentName;
                    $data->employeeWise->add($node);
                }
            }
        }

        //branchwise
        foreach ($allocatedBranch as $allocatedRow) {
            foreach ($assignedBranch as $assignedRow) {
                if ($allocatedRow->branchId == $assignedRow->branchId) {
                    $node = new stdClass;
                    $node->allocatedCalls = $allocatedRow->allocatedCalls;
                    $node->dialledCalls = $assignedRow->dialledCalls;
                    $node->ansCalls = $assignedRow->ansCalls;
                    $node->branchName = $assignedRow->branchName;
                    $data->branchWise->add($node);
                }
            }
        }
        return $data;
    }

    function coreAgentSql($args)
    {
        //getting agent details
        $sql = AgentMaster::where('agent_master.status', AgentMaster::STATUS_ACTIVE);
        // ->join('agent_mapping', 'agent_mapping.agent_id', 'agent_master.id');
        if ($args->branch != 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        if (isset($args->branchIds) && count($args->branchIds) > 0) {
            $sql->whereIn('agent_master.branch_id', $args->branchIds);
        }
        return $sql;
    }

    function coreAgentLoginSql($args)
    {
        $sql = AgentsLogin::join('agent_master', 'agent_master.id', 'agents_login.agent_id')
            ->join('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->where('agents_login.date', Carbon::now()->format('Y-m-d'));
        if ($args->branch != 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        if (isset($args->branchIds) && count($args->branchIds) > 0) {
            $sql->whereIn('agent_master.branch_id', $args->branchIds);
        }
        return $sql;
    }

    function coreBranchSql($args)
    {
        $sql = BranchMaster::whereStatus(BranchMaster::STATUS_ACTIVE);
        if ($args->branch != 'All') {
            $sql->where('id', $args->branch);
        }
        return $sql;
    }

    function addBranchData($data, $args)
    {
        //getting branch details
        $sql = $this->coreBranchSql($args);
        $branch = $sql->count();

        //getting agent details
        $sql = $this->coreAgentSql($args);
        $agent = $sql->count();

        //logged in users
        $sql = $this->coreAgentLoginSql($args);
        $loggedUsers = $sql->count();

        $node = new stdClass;
        $node->count = $branch;
        $node->description = 'No of Branch';
        $node->class = $this->getDesignClass(1);
        $node->fafaIcon = 'fa fa-university';
        $node->refId = '0';
        $data->branchDetails->rows->add($node);

        $node = new stdClass;
        $node->count = $agent;
        $node->description = 'No of Employee';
        $node->class = $this->getDesignClass(2);
        $node->fafaIcon = 'fa fa-users';
        $node->refId = '0';
        $data->branchDetails->rows->add($node);

        $node = new stdClass;
        $node->count = 0;
        $node->description = 'Employee Present';
        $node->class = $this->getDesignClass(3);
        $node->fafaIcon = 'fa fa-user';
        $node->refId = '0';
        $data->branchDetails->rows->add($node);

        $node = new stdClass;
        $node->count = $loggedUsers;
        $node->description = 'Employee Logged In';
        $node->class = $this->getDesignClass(0);
        $node->fafaIcon = 'fa fa-address-card';
        $node->refId = '0';
        $data->branchDetails->rows->add($node);
    }

    function salesMatixCore($args)
    {
        $sql = Sales::select(
            DB::raw('COUNT(sales.id) as totalSales'),
            DB::raw('COUNT(sales.beneficiary_id) as salesConverted'),
        )
            ->leftJoin('beneficiary_import', 'beneficiary_import.id', 'sales.beneficiary_id')
            // ->whereDate('sales.invoice_date', '>=', $args->fromDate)
            // ->whereDate('sales.invoice_date', '<=', $args->toDate);
            ->whereBetween('sales.invoice_date', [$args->fromDate, $args->toDate]);
        if ($args->branch  != 'All') {
            $sql->where('sales.branch_id', $args->branch);
        }
        if ($args->agent != 'All') {
            $sql->where('beneficiary_import.agent_id', $args->agent);
        }
        if (isset($args->source) && $args->source != 'All') {
            $sql->where('beneficiary_import.source', $args->source);
        }
        if (isset($args->branchIds) && count($args->branchIds) > 0) {
            $sql->whereIn('sales.branch_id', $args->branchIds);
        }
        return $sql;
    }

    function enquiryMatixCore($args)
    {
        $sql = EnquiryHistory::select(
            DB::raw('COUNT(enquiry_history.id) as totalEnquiry'),
            DB::raw('COUNT(CASE WHEN feedback.call_skip_reason IN (12,13) THEN feedback.id END) as leadConverted'),
        )
            ->join('beneficiary_import', 'beneficiary_import.id', 'enquiry_history.beneficiary_id')
            ->leftJoin('feedback', 'feedback.beneficiary_ref_id', 'beneficiary_import.id')
            // ->whereDate('enquiry_history.date', '>=', $args->fromDate)
            // ->whereDate('enquiry_history.date', '<=', $args->toDate);
            ->whereBetween('enquiry_history.date', [$args->fromDate, $args->toDate]);
        if ($args->branch  != 'All') {
            $sql->where('enquiry_history.branch_id', $args->branch);
        }
        if ($args->agent != 'All') {
            $sql->where('beneficiary_import.agent_id', $args->agent);
        }
        if (isset($args->branchIds) && count($args->branchIds) > 0) {
            $sql->whereIn('enquiry_history.branch_id', $args->branchIds);
        }
        if (isset($args->source) && $args->source != 'All') {
            $sql->where('beneficiary_import.source', $args->source);
        }
        return $sql;
    }

    function addSalesMatrix($data, $args)
    {
        $sql = $this->salesMatixCore($args);
        $sales = $sql->first();

        $sqlE = $this->enquiryMatixCore($args);
        $enquiry = $sqlE->first();

        $node = new stdClass;
        $node->count = isset($sales->salesConverted) ? $sales->salesConverted : 0;
        $node->count1 = isset($sales->totalSales) ? $sales->totalSales : 0;
        $node->dualCount = true;
        $node->description = 'No of Sales';
        $node->class = $this->getDesignClass(0);
        $node->fafaIcon = 'fa fa-shopping-cart';
        $node->refId = '0';
        $data->salesMatrix->rows->add($node);

        $node = new stdClass;
        $node->count = isset($enquiry->leadConverted) ? $enquiry->leadConverted : 0;
        $node->count1 = isset($enquiry->totalEnquiry) ? $enquiry->totalEnquiry : 0;
        $node->dualCount = true;
        $node->description = 'Lead Converted';
        $node->class = $this->getDesignClass(1);
        $node->fafaIcon = 'fa fa-pie-chart';
        $node->refId = '0';
        $data->salesMatrix->rows->add($node);
    }

    function coreAgentCallDetails($arguments)
    {
        $fromDate = Carbon::parse($arguments->fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($arguments->toDate)->format('Y-m-d');

        $sql = Feedback::join('beneficiary_import', 'beneficiary_import.id', 'feedback.beneficiary_ref_id')
            ->where('feedback.created_at', '>=', $fromDate . ' 00:00:00')
            ->where('feedback.created_at', '<=', $toDate . ' 23:59:59');
        if ($arguments->branch  != 'All') {
            $sql->where('beneficiary_import.branch_id', $arguments->branch);
        }
        if ($arguments->agent != 'All') {
            $sql->where('beneficiary_import.agent_id', $arguments->agent);
        }
        if (isset($arguments->branchIds) && count($arguments->branchIds) > 0) {
            $sql->whereIn('beneficiary_import.branch_id', $arguments->branchIds);
        }
        if (isset($arguments->source) && $arguments->source != 'All') {
            $sql->where('beneficiary_import.source', $arguments->source);
        }
        return $sql;
    }

    function coreAgentAssignFollowDetails($arguments)
    {
        $fromDate = Carbon::parse($arguments->fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($arguments->toDate)->format('Y-m-d');
        $sql = BeneficiaryImport::leftJoin('feedback', 'feedback.beneficiary_ref_id', 'beneficiary_import.id');
        if ($arguments->branch  != 'All') {
            $sql->where('beneficiary_import.branch_id', $arguments->branch);
        }
        if ($arguments->agent != 'All') {
            $sql->where('beneficiary_import.agent_id', $arguments->agent);
        }
        if (isset($arguments->source) && $arguments->source != 'All') {
            $sql->where('beneficiary_import.source', $arguments->source);
        }

        if (isset($arguments->type) && $arguments->type == 'follow-up') {
            //for follow up
            $sql->where('beneficiary_import.callback_on', '>=', $fromDate . ' 00:00:00');
            $sql->where('beneficiary_import.callback_on', '<=', $toDate . ' 23:59:59');
        } else {
            // for assigned
            $sql->where('beneficiary_import.created_at', '>=', $fromDate . ' 00:00:00');
            $sql->where('beneficiary_import.created_at', '<=', $toDate . ' 23:59:59');
        }
        if (isset($arguments->branchIds) && count($arguments->branchIds) > 0) {
            $sql->whereIn('beneficiary_import.branch_id', $arguments->branchIds);
        }
        return $sql;
    }

    function addAgentCallDetails($data, $arguments)
    {
        $sql = $this->coreAgentCallDetails($arguments);
        $cloneSql = clone $sql;
        //for reasonwise calls
        $cloneSql->leftJoin('call_skip_reason', 'call_skip_reason.id', 'feedback.call_skip_reason');
        $cloneSql->select(
            'call_skip_reason.name',
            'call_skip_reason.is_answered',
            'call_skip_reason.id',
            DB::raw('COUNT(feedback.id) as total'),
        )->groupBy('call_skip_reason.id');
        $reasons = $cloneSql->get();

        $key = 0;
        $icon = 0;
        $answerdCount = 0;
        $unAnswerdCount = 0;

        if ($reasons) {
            foreach ($reasons as $key => $callReason) {
                if ($key > 4) {
                    $key = 0;
                }
                if ($icon > 6) {
                    $icon = 0;
                }
                $node = new stdClass;
                $node->count = $callReason->total;
                $node->description = $callReason->name;
                $node->class = $this->getDesignClass($key);
                $node->fafaIcon = $this->getIcons($icon);
                $node->refId = $callReason->id;

                if ($callReason->is_answered) {
                    $answerdCount += $callReason->total;
                    $data->answered->rows->add($node);
                } else {
                    $unAnswerdCount += $callReason->total;
                    $data->unAnswered->rows->add($node);
                }
                $key++;
                $icon++;
            }
        }

        //for overall totals
        $sql->select(
            DB::raw('COUNT(feedback.id) as totalCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as connectedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 2 THEN feedback.id END) as notConnectedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_type = 2 THEN feedback.id END) as followupCompletedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_type = 1 THEN feedback.id END) as allocatedCompletedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_skip_reason = 13 THEN feedback.id END) as todayVisitCalls'),
        );
        $feedback = $sql->first();

        //get follow up counts
        $arguments->type = 'follow-up';
        $cloneSql1 = $this->coreAgentAssignFollowDetails($arguments);
        $followUp = $cloneSql1->select(
            DB::raw('COUNT(beneficiary_import.id) as totalCalls'),
        )->first();
        $arguments->type = null;
        $assSql = $this->coreAgentAssignFollowDetails($arguments);
        $assigned = $assSql->select(
            DB::raw('COUNT(beneficiary_import.id) as totalCalls'),
        )->first();

        //total Calls
        $node = new stdClass;
        $node->count = isset($feedback->totalCalls) ? $feedback->totalCalls : 0;
        $node->description = 'Total Calls';
        $node->class = $this->getDesignClass(1);
        $node->fafaIcon = 'fa fa-phone';
        $node->refId = '0';
        $data->callHistory->rows->add($node);

        $node = new stdClass;
        $node->count = isset($feedback->connectedCalls) ? $feedback->connectedCalls : 0;
        $node->description = 'Connected';
        $node->class = $this->getDesignClass(2);
        $node->fafaIcon = 'fa fa-volume-control-phone';
        $node->refId = '0';
        $data->callHistory->rows->add($node);

        $node = new stdClass;
        $node->count = isset($feedback->notConnectedCalls) ? $feedback->notConnectedCalls : 0;
        $node->description = 'Not Connected';
        $node->class = $this->getDesignClass(3);
        $node->fafaIcon = 'fa fa-window-close';
        $node->refId = '0';
        $data->callHistory->rows->add($node);

        $node = new stdClass;
        $node->count = isset($assigned->totalCalls) ? $assigned->totalCalls : 0;
        $node->count1 = isset($feedback->allocatedCompletedCalls) ? $feedback->allocatedCompletedCalls : 0;
        $node->description = 'Allocated / Completed';
        $node->class = $this->getDesignClass(3);
        $node->fafaIcon = 'fa fa-phone-square';
        $node->refId = '0';
        $node->dualCount = true;
        $data->callHistory->rows->add($node);

        $node = new stdClass;
        $node->count = isset($followUp->totalCalls) ? $followUp->totalCalls : 0;
        $node->count1 = isset($feedback->followupCompletedCalls) ? $feedback->followupCompletedCalls : 0;
        $node->description = 'Follow up / Completed';
        $node->class = $this->getDesignClass(3);
        $node->fafaIcon = 'fa fa-volume-control-phone';
        $node->refId = '0';
        $node->dualCount = true;
        $data->callHistory->rows->add($node);

        $node = new stdClass;
        $node->count = isset($feedback->todayVisitCalls) ? $feedback->todayVisitCalls : 0;
        $node->description = 'Today Customer Visit';
        $node->class = $this->getDesignClass(3);
        $node->fafaIcon = 'fa fa-eye';
        $node->refId = '0';
        $data->callHistory->rows->add($node);
    }

    public function getAgentCallDetails($arguments, $data)
    {
        $this->addAgentCallDetails($data, $arguments);
        $this->addBranchData($data, $arguments);
        $this->addSalesMatrix($data, $arguments);
        return $data;
    }

    public function getIcons($index)
    {
        $icons = [
            'fa fa-window-close',
            'fa fa-bell-slash',
            'fa fa-user',
            'fa fa-check',
            'fa fa-files-o',
            'fa fa-mobile',
            'fa fa-exclamation-triangle',
        ];
        return $icons[$index];
    }

    public function getDesignClass($index)
    {
        $class = [
            'text-danger',
            'text-success',
            'text-warning',
            'text-info',
            'text-primary',
        ];
        return $class[$index];
    }

    public function getDashboardData(Request $request)
    {

        return $this->getAdminDashboardData($request);
        // $authDetails = Auth::user();
        // $role = $authDetails->role;
        // $userType = $authDetails->user_type;
        // if (is_null($role) || in_array($role, RoleMaster::ADMIN_DASHBOARD_ROLES)) {
        //     $request->roleType = 'admin';
        //     return $this->getAdminDashboardData($request);
        // } else if ($role == RoleMaster::ROLE_CLUSTER) {
        //     $request->roleType = 'cluster';
        //     return $this->getAdminDashboardData($request);
        // }
    }

    function processAppFilters(Request $request)
    {
        $userId = $request->user()->reference_id;
        //get agent mapped branch
        $branch = 'n/a';
        $mapping = AgentMaster::find($userId);
        if ($mapping) {
            $branch = $mapping->branch_id;
        }
        $arguments = new stdClass;
        $arguments->branch = $branch;
        $arguments->agent = $userId;
        if ($request->dateRange) {
            $dateRange = strtolower($request->dateRange);
            if ($dateRange == 'yesterday') {
                $fromDate = Carbon::now()->subDay()->format('Y-m-d');
                $toDate = Carbon::now()->subDay()->format('Y-m-d');
            } else if ($dateRange == 'this week') {
                $fromDate = Carbon::now()->startOfWeek()->format('Y-m-d');
                $toDate = Carbon::now()->endOfWeek()->format('Y-m-d');
            } else if ($dateRange == 'this month') {
                $fromDate = Carbon::now()->startOfMonth()->format('Y-m-d');
                $toDate = Carbon::now()->format('Y-m-d');
            } else {
                $fromDate = Carbon::now()->format('Y-m-d');
                $toDate = Carbon::now()->format('Y-m-d');
            }
        }
        $arguments->fromDate = $fromDate;
        $arguments->toDate = $toDate;
        return $arguments;
    }

    function appUserDashboard(Request $request)
    {
        $data = new AppDashboard;
        $arguments = $this->processAppFilters($request);

        // date range start
        //get date range count for connected and not connected calls
        $connSql = $this->coreAgentCallDetails($arguments);
        $connSql->select(
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as connectedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 2 THEN feedback.id END) as notConnectedCalls'),
        );
        $connSql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_EXCEL);
        $connDetails = $connSql->first();

        //get date range count for assigned calls
        $assSql = $this->coreAgentAssignFollowDetails($arguments);
        $assSql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_EXCEL);
        $assSql->select(
            DB::raw('COUNT(beneficiary_import.id) as assignedCalls'),
        );
        $assignDetails = $assSql->first();
        // date range end

        // today date start
        //get today date count for connected and not connected calls
        $arguments->fromDate = Carbon::now()->format('Y-m-d');
        $arguments->toDate = Carbon::now()->format('Y-m-d');
        $connSql = $this->coreAgentCallDetails($arguments);
        $connSql->select(
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as connectedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 2 THEN feedback.id END) as notConnectedCalls'),
        );
        $connSqlJust = clone $connSql;
        $connSqlCrm = clone $connSql;
        $connSqlSap = clone $connSql;
        $connSqlCampaign = clone $connSql;
        $connSqlHappy = clone $connSql;

        $connSql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_EXCEL);
        $connDetailsToday = $connSql->first();

        //justdial
        $connSqlJust->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_JUST_DIAL);
        $connDetailsJust = $connSqlJust->first();

        //crm
        $connSqlCrm->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_CRM);
        $connDetailsCrm = $connSqlCrm->first();

        //sap
        $connSqlSap->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_SAP);
        $connDetailsSap = $connSqlSap->first();

        //excel campaign
        $connSqlCampaign->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_EXCEL_CAMPAIGN);
        $connDetailsCampaign = $connSqlCampaign->first();

        //happy calls
        $connSqlHappy->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_HAPPY_CALLS);
        $connDetailsHappy = $connSqlHappy->first();

        //get today date count for assigned calls
        // $assSql = $this->coreAgentAssignFollowDetails($arguments);
        // $assSql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_EXCEL);
        // $assSql->select(
        //     DB::raw('COUNT(beneficiary_import.id) as assignedCalls'),
        // );
        // $assignDetailsToday = $assSql->first();
        // today date end

        $assignedData = $this->callCenterService->getDialerCounts($request, 'app-dashboard');
        $assignedCounts = json_decode($assignedData->content());

        //assign value to today variables
        $data->today->connected = isset($connDetailsToday->connectedCalls) ? $connDetailsToday->connectedCalls : 0;
        $data->today->notConnected = isset($connDetailsToday->notConnectedCalls) ? $connDetailsToday->notConnectedCalls : 0;
        $data->today->assigned = $assignedCounts->allocatedTelecalling + $data->today->connected + $data->today->notConnected;

        //assigned crm and justdial counts
        // $arguments->isJustDial = 1;
        // $justDialCount = $this->assignedCountsCrmJustDial($request, $arguments);
        // $arguments->isJustDial = null;
        // $arguments->isCRMLead = 1;
        // $crmCount = $this->assignedCountsCrmJustDial($request, $arguments);
        // $arguments->isJustDial = null;
        // $arguments->isCRMLead = null;
        // $arguments->isSAPLead = 1;
        // $sapCount = $this->assignedCountsCrmJustDial($request, $arguments);
        // $arguments->isJustDial = null;
        // $arguments->isCRMLead = null;
        // $arguments->isSAPLead = null;
        // $arguments->isCampaignLead = 1;
        // $campaignCount = $this->assignedCountsCrmJustDial($request, $arguments);

        //crm
        $data->today->connectedCrm = isset($connDetailsCrm->connectedCalls) ? $connDetailsCrm->connectedCalls : 0;
        $data->today->notConnectedCrm = isset($connDetailsCrm->notConnectedCalls) ? $connDetailsCrm->notConnectedCalls : 0;
        $data->today->assignedCrm = $assignedCounts->allocatedCRM + $data->today->connectedCrm + $data->today->notConnectedCrm;

        //sap
        $data->today->connectedSap = isset($connDetailsSap->connectedCalls) ? $connDetailsSap->connectedCalls : 0;
        $data->today->notConnectedSap = isset($connDetailsSap->notConnectedCalls) ? $connDetailsSap->notConnectedCalls : 0;
        $data->today->assignedSap = $assignedCounts->allocatedSAP + $data->today->connectedSap + $data->today->notConnectedSap;

        //excel campaign
        $data->today->connectedCampaign = isset($connDetailsCampaign->connectedCalls) ? $connDetailsCampaign->connectedCalls : 0;
        $data->today->notConnectedCampaign = isset($connDetailsCampaign->notConnectedCalls) ? $connDetailsCampaign->notConnectedCalls : 0;
        $data->today->assignedCampaign = $assignedCounts->allocatedCampaign + $data->today->connectedCampaign + $data->today->notConnectedCampaign;

        //justdial
        $data->today->connectedJustdial = isset($connDetailsJust->connectedCalls) ? $connDetailsJust->connectedCalls : 0;
        $data->today->notConnectedJustdial = isset($connDetailsJust->notConnectedCalls) ? $connDetailsJust->notConnectedCalls : 0;
        $data->today->assignedJustdial = $assignedCounts->allocatedJustDial + $data->today->connectedJustdial + $data->today->notConnectedJustdial;

        //happy calls
        $data->today->connectedHappyCalls = isset($connDetailsHappy->connectedCalls) ? $connDetailsHappy->connectedCalls : 0;
        $data->today->notConnectedHappyCalls = isset($connDetailsHappy->notConnectedCalls) ? $connDetailsHappy->notConnectedCalls : 0;
        $data->today->assignedHappyCalls = $assignedCounts->allocatedHappyCalls + $data->today->connectedHappyCalls + $data->today->notConnectedHappyCalls;

        //assign value to datarange variables
        $data->callHistory->connected = isset($connDetails->connectedCalls) ? $connDetails->connectedCalls : 0;
        $data->callHistory->notConnected = isset($connDetails->notConnectedCalls) ? $connDetails->notConnectedCalls : 0;
        $historyAssigned = isset($assignDetails->assignedCalls) ? $assignDetails->assignedCalls : 0;
        $data->callHistory->assigned = $historyAssigned + $data->callHistory->connected + $data->callHistory->notConnected;

        //sales matrix data
        $sql = $this->salesMatixCore($arguments);
        $sql->addSelect(DB::raw('SUM(sales.amount) as amount'));
        $sales = $sql->first();

        //assign values to sales matrix data
        $data->sales->noOfSales = isset($sales->salesConverted) ? $sales->salesConverted : 0;
        $data->sales->salesValue = isset($sales->amount) ? $sales->amount : 0;

        return response()->json($data);
    }

    // public function assignedCountsCrmJustDial(Request $request, $arguments)
    // {
    //     $sql = DB::table('beneficiary_import')
    //         ->leftJoin('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
    //         ->whereNull('beneficiary_import.deleted_at');
    //     if (isset($arguments->isJustDial) && $arguments->isJustDial) {
    //         $leadAccess = BranchLeadsAssign::select('branch_id')
    //             ->where('user_id', $request->user()->id)
    //             ->first();
    //         if ($leadAccess && $leadAccess->branch_id) {
    //             $sql->where('beneficiary_import.branch_id', $leadAccess->branch_id);
    //             $sql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_JUST_DIAL);
    //         } else {
    //             return 0;
    //         }
    //     }
    //     if (isset($arguments->isCRMLead) && $arguments->isCRMLead) {
    //         $leadAccess = AgentMaster::find($request->user()->reference_id);
    //         if ($leadAccess && $leadAccess->crm_lead_assign == 1) {
    //             $sql->where('beneficiary_import.branch_id', $leadAccess->branch_id);
    //             $sql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_CRM);
    //         } else {
    //             return 0;
    //         }
    //     }
    //     if (isset($arguments->isSAPLead) && $arguments->isSAPLead) {
    //         $leadAccess = AgentMaster::find($request->user()->reference_id);
    //         if ($leadAccess && $leadAccess->sap_lead_assign == 1) {
    //             $sql->where('beneficiary_import.branch_id', $leadAccess->branch_id);
    //             $sql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_SAP);
    //         } else {
    //             return 0;
    //         }
    //     }
    //     if (isset($arguments->isCampaignLead) && $arguments->isCampaignLead) {
    //         $agent = $this->excelCampaignService->getExcelCampaignUserDetails($request->user());
    //         if ($agent) {
    //             $sql->where('beneficiary_import.branch_id', $agent->branch_id);
    //             $sql->where('beneficiary_import.source', BeneficiaryImport::SOURCE_TYPE_EXCEL_CAMPAIGN);
    //         } else {
    //             return 0;
    //         }
    //     }
    //     return $sql->count();
    // }


    public function getBranches(Request $request)
    {
        $branches = ClusterBranchMapping::select('branch_master.id', 'branch_master.name')
            ->join('branch_master', 'branch_master.id', '=', 'cluster_branch_mapping.branch_id')
            ->where('cluster_branch_mapping.cluster_id', $request->clusterId)
            ->get();

        return response()->json($branches);
    }

    //for excel export dashboard counts
    function getDetailedReport($request)
    {
        return $this->getDetailedExcel($request);
    }

    function getDetailedExcel($request)
    {
        // dd($request);
        $callReason = CallSkipReason::pluck('name');
        $callReasonArray = $callReason->toArray();
        $fieldType = $request->fieldType;
        if (in_array($fieldType, $callReasonArray)) {
            $fieldType = 'Dynamic Fields';
        }

        switch ($fieldType) {
            case 'Connected':
            case 'Total Calls':
            case 'Not Connected':
            case 'Allocated  Completed':
            case 'Follow up  Completed':
            case 'Today Customer Visit':
            case 'Dynamic Fields':
                $sql = $this->coreAgentCallDetails($request);
                if ($fieldType == 'Connected') {
                    $sql->where('feedback.call_status', 1);
                }
                if ($fieldType == 'Not Connected') {
                    $sql->where('feedback.call_status', 2);
                }
                if ($fieldType == 'Allocated  Completed') {
                    $sql->where('feedback.call_type', 1);
                }
                if ($fieldType == 'Follow up  Completed') {
                    $sql->where('feedback.call_type', 2);
                }
                if ($fieldType == 'Today Customer Visit') {
                    $sql->where('feedback.call_skip_reason', 13);
                }
                if (in_array($request->fieldType, $callReasonArray)) {
                    $sql->leftJoin('call_skip_reason', 'call_skip_reason.id', 'feedback.call_skip_reason');
                    $sql->where('call_skip_reason.name', $request->fieldType);
                    $fieldType = $request->fieldType;
                }
                $sql->leftJoin('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
                    ->leftJoin('agent_master', 'agent_master.id', 'feedback.created_by')
                    ->select(
                        'beneficiary_import.customer_name',
                        'beneficiary_import.mobile_number',
                        'beneficiary_import.invoice_date',
                        'beneficiary_import.description',
                        'feedback.created_at',
                        'branch_master.name as branchName',
                        'agent_master.name as agentName',
                    );
                $data = $sql->get();

                if ($fieldType == 'Allocated  Completed' || $fieldType ==  'Follow up  Completed') {

                    $request->title1 = 'Allocated';
                    $request->title = 'Completed';
                    $request->type = null;

                    if ($fieldType == 'Follow up  Completed') {
                        $request->title1 = 'FollowUp';
                        $request->type = 'follow-up';
                    }

                    $assSql = $this->coreAgentAssignFollowDetails($request);
                    $assSql->leftJoin('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
                        ->leftJoin('agent_master', 'agent_master.id', 'feedback.created_by')
                        ->select(
                            'beneficiary_import.customer_name',
                            'beneficiary_import.mobile_number',
                            'beneficiary_import.invoice_date',
                            'beneficiary_import.description',
                            'feedback.created_at',
                            'branch_master.name as branchName',
                            'agent_master.name as agentName',
                        );
                    $data1 = $assSql->get();
                    return $this->dashboardDetailedReportExport->exportCallHistoryTwoSheet($request, $data, $data1);
                    break;
                }

                return $this->dashboardDetailedReportExport->exportCallHistory($request, $data);
                break;
            case 'No of Sales':
                $sql = $this->salesMatixCore($request);
                $sql->leftJoin('agent_master', 'agent_master.id', 'beneficiary_import.agent_id')
                    ->leftJoin('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
                    ->select(
                        'sales.customer_name',
                        'sales.mobile',
                        'sales.invoice_date as date',
                        'sales.product',
                        'sales.description',
                        'branch_master.name as branchName',
                        'agent_master.name as agentName',
                        'sales.beneficiary_id'
                    );
                $data = $sql->get();
                $data1 = $data->filter(function ($item) {
                    return !is_null($item->beneficiary_id);
                });

                $request->title = 'Sales';
                $request->title1 = 'Converted';
                return $this->dashboardDetailedReportExport->exportSalesAndEnquiry($request, $data, $data1);
                break;
            case 'Lead Converted':

                $sql = $this->enquiryMatixCore($request);
                $sql->leftJoin('agent_master', 'agent_master.id', 'beneficiary_import.agent_id')
                    ->leftJoin('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
                    ->select(
                        'enquiry_history.customer_name',
                        'enquiry_history.mobile',
                        'enquiry_history.date',
                        'enquiry_history.product',
                        'enquiry_history.description',
                        'branch_master.name as branchName',
                        'agent_master.name as agentName'
                    );
                $cloneSql = clone $sql;
                $data = $sql->get();

                $cloneSql->whereIn('feedback.call_skip_reason', [12, 13]);
                $data1 = $cloneSql->get();

                $request->title = 'Enquiry';
                $request->title1 = 'Converted';
                return $this->dashboardDetailedReportExport->exportSalesAndEnquiry($request, $data, $data1);
                break;
            case 'No of Branch':
                $sql = $this->coreBranchSql($request);
                $data = $sql->select('name')->get();
                return $this->dashboardDetailedReportExport->exportBranches($request, $data);
                break;
            case 'No of Employee':
                $sql = $this->coreAgentSql($request)
                    ->join('branch_master', 'branch_master.id', 'agent_master.branch_id');
                $data = $sql->select(
                    'agent_master.name as agentName',
                    'branch_master.name as branchName',
                )->get();
                return $this->dashboardDetailedReportExport->exportAgents($request, $data);
                break;
            case 'Employee Logged In':
                $sql = $this->coreAgentLoginSql($request);
                $data = $sql->select(
                    'agent_master.name as agentName',
                    'branch_master.name as branchName',
                )->get();
                return $this->dashboardDetailedReportExport->exportAgents($request, $data);
                break;
            default:
                echo 'no records found';
                break;
        }
    }
}
