<?php

namespace App\Services\Master;

use App\Models\Masters\AwcMaster;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class AwcService
{

    public function __construct()
    {

    }

    public function getData()
    {
        $sql = DB::table('awc_master')
            ->join('block_master', 'block_master.id', 'awc_master.block_id')
            ->join('city_master', 'city_master.id', 'awc_master.district_id')
            ->join('sector_master', 'sector_master.id', 'awc_master.sector_id')
            ->select('awc_master.name', 'block_master.name as block_name', 'awc_master.status', 'awc_master.id','city_master.name as district_name','sector_master.name as sector_name','awc_master.code')
            ->whereNull('awc_master.deleted_at');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = AwcMaster::find($id);
            $data->route = route('awc-master.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new AwcMaster();
            $data->route = route('awc-master.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('awc-master.index');
        $data->breadcrumbTitle = 'Awc Master';
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $block = $request->has('block') ? $request->get('block') : '';
        $district = $request->has('district') ? $request->get('district') : '';
        $sector = $request->has('sector') ? $request->get('sector') : '';
        $block = $request->has('block') ? $request->get('block') : '';
        $awcId = $request->has('awcId') ? $request->get('awcId') : '';

        if ($awcId) {
            $data = AwcMaster::find($awcId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new AwcMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;
        $data->block_id = $block;
        $data->district_id = $district;
        $data->sector_id = $sector;
        $data->save();

        if ($data) {
            return true;
        }
    }

}
