<?php

namespace App\Services\Master;

use App\Models\Masters\BlockMaster;
use App\Models\Masters\CityMaster;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class BlockMasterService
{

    public function __construct()
    {
    }

    public function getBlockData()
    {
        $city = DB::table('block_master')
            ->join('city_master', 'city_master.id', 'block_master.district_id')
            ->select('city_master.name as district_name', 'block_master.name', 'block_master.status', 'block_master.id', 'block_master.code')
            ->whereNull('block_master.deleted_at');
        return $city;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = BlockMaster::find($id);
            $data->route = route('block.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new BlockMaster();
            $data->route = route('block.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('block.index');
        $data->breadcrumbTitle = 'Block';
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $district = $request->has('district') ? $request->get('district') : '';
        $blockId = $request->has('blockId') ? $request->get('blockId') : '';

        if ($blockId) {
            $data = BlockMaster::find($blockId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new BlockMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;
        $data->district_id = $district;
        $data->save();

        if ($data) {
            return true;
        }
    }
}
