<?php

namespace App\Services\Master;

use App\Models\Masters\BrandMaster;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class BrandService
{

    public function __construct()
    {
    }

    public function getData()
    {
        $data = BrandMaster::orderBy('id');
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = BrandMaster::find($id);
            $data->route = route('brand.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new BrandMaster();
            $data->route = route('brand.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('brand.index');
        $data->breadcrumbTitle = 'Brand';

        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        
        if ($id) {
            $data = BrandMaster::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new BrandMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;
        
        $data->save();

        if ($data) {
            return true;
        }
    }
}
