<?php

namespace App\Services\Master;

use App\Models\Masters\CityMaster;
use App\Models\Masters\StateMaster;
use Illuminate\Http\Request as HttpRequest;
use DB;
use Illuminate\Support\Facades\Auth;

class DistrictService
{

    public function __construct()
    {
    }

    public function getDistrictData()
    {
        $city = DB::table('city_master')
            ->join('state_master', 'state_master.id', 'city_master.state')
            ->select('city_master.id', 'city_master.name', 'city_master.status', 'state_master.name as state','city_master.code')
            ->whereNull('city_master.deleted_at');
        // ->get();
        return $city;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $district = CityMaster::find($id);
            $district->route = route('district.update', $id);
            $district->method = 'PUT';
            $district->breadcrumbName = 'Edit';
        } else {
            $district = new CityMaster();
            $district->route = route('district.store');
            $district->method = 'POST';
            $district->breadcrumbName = 'Create';
        }
        $district->breadcrumbAction = route('district.index');
        $district->breadcrumbTitle = 'District';

        return $district;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $state = $request->has('state') ? $request->get('state') : '';
        $districtId = $request->has('districtId') ? $request->get('districtId') : '';

        if ($districtId) {
            $data = CityMaster::find($districtId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new CityMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;
        $data->state = $state;
        $data->save();

        if ($data) {
            return true;
        }
    }
}
