<?php

namespace App\Services\Master;

use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\EscalationMatrixLevels;
use App\Models\Masters\ProgramMaster;
use App\Models\Masters\AwcMaster;
use App\Models\Masters\SectorMaster;
use App\Models\Masters\BlockMaster;
use App\Models\RoleMaster;
use App\Models\User;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Log;

class EscalationMatrixService
{

    public function __construct()
    {

    }

    public function getData()
    {
        $sql = DB::table('escalation_matrix')
        // ->join('scheme_master', 'scheme_master.id', 'escalation_matrix.scheme_id')
        // ->join('program_master', 'program_master.id', 'escalation_matrix.program_id')
            ->join('city_master', 'city_master.id', 'escalation_matrix.district_id')
            ->join('block_master', 'block_master.id', 'escalation_matrix.block_id')
            ->join('sector_master', 'sector_master.id', 'escalation_matrix.sector_id')
            ->join('awc_master', 'awc_master.id', 'escalation_matrix.awc_id')
            ->select('escalation_matrix.status', 'escalation_matrix.id', 'city_master.name as district', 'awc_master.name as awc', 'block_master.name as block', 'sector_master.name as sector','awc_master.code',
                DB::raw('"All" as scheme, "All" as program'),
            );
        $sql->whereNull('escalation_matrix.deleted_at');
        // $data = $sql->get();
        return $sql;
    }

    public function showData($id)
    {
        $data = DB::table('escalation_matrix')
        // ->join('scheme_master', 'scheme_master.id', 'escalation_matrix.scheme_id')
        // ->join('program_master', 'program_master.id', 'escalation_matrix.program_id')
            ->join('city_master', 'city_master.id', 'escalation_matrix.district_id')
            ->join('block_master', 'block_master.id', 'escalation_matrix.block_id')
            ->join('sector_master', 'sector_master.id', 'escalation_matrix.sector_id')
            ->join('awc_master', 'awc_master.id', 'escalation_matrix.awc_id')
            ->select('escalation_matrix.status', 'escalation_matrix.id', 'city_master.name as district', 'awc_master.name as awc', 'block_master.name as block', 'sector_master.name as sector',
                DB::raw('"All" as scheme, "All" as program'),
            )
            ->where('escalation_matrix.id', $id)
            ->first();
        if ($data) {
            $data->items = EscalationMatrixLevels::where('escalation_reference_id', $id)->get();
            return $data;
        }

    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = EscalationMatrix::find($id);
            $data->route = route('escalation-matrix.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->escLevels = EscalationMatrixLevels::where('escalation_reference_id', $id)->get();
            $data->programList = ProgramMaster::where('scheme_id', $data->scheme_id)->whereStatus(ProgramMaster::STATUS_ACTIVE)->get();
            $data->blockList = BlockMaster::where('district_id', $data->district_id)->whereStatus(BlockMaster::STATUS_ACTIVE)->get();
            $data->sectorList = SectorMaster::where('block_id', $data->block_id)->whereStatus(SectorMaster::STATUS_ACTIVE)->get();
            $data->awcList = AwcMaster::where('sector_id', $data->sector_id)->whereStatus(AwcMaster::STATUS_ACTIVE)->get();
        } else {
            $data = new EscalationMatrix();
            $data->route = route('escalation-matrix.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
            $data->escLevels = [];
            $data->programList = [];
            $data->blockList = [];
            $data->sectorList = [];
            $data->awcList = [];
        }
        $data->breadcrumbAction = route('escalation-matrix.index');
        $data->breadcrumbTitle = 'Escalation Matrix';

        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        try {
            DB::beginTransaction();

            $schemeId = $request->has('scheme') ? $request->get('scheme') : '';
            $programId = $request->has('program') ? $request->get('program') : '';
            $districtId = $request->has('district') ? $request->get('district') : '';
            $block = $request->has('block') ? $request->get('block') : '';
            $sector = $request->has('sector') ? $request->get('sector') : '';
            $awc = $request->has('awc') ? $request->get('awc') : '';
            $uniqueId = $request->has('uniqueId') ? $request->get('uniqueId') : '';

            if ($schemeId == 'All') {
                $schemeId = null;
            }
            if ($programId == 'All') {
                $programId = null;
            }

            if ($uniqueId) {
                $data = EscalationMatrix::find($uniqueId);
                $data->updated_by = Auth::user()->id;
            } else {
                $data = new EscalationMatrix();
                $data->created_by = Auth::user()->id;
                $data->updated_by = Auth::user()->id;
            }
            $data->scheme_id = $schemeId;
            $data->program_id = $programId;
            $data->district_id = $districtId;
            $data->block_id = $block;
            $data->sector_id = $sector;
            $data->awc_id = $awc;
            $data->save();
            $lastId = $data->id;

            if ($lastId) {

                EscalationMatrixLevels::where('escalation_reference_id', $lastId)->delete();

                $levels = $request->has('name') ? $request->get('name') : '';
                $mobile = $request->has('mobile') ? $request->get('mobile') : '';
                $email = $request->has('email') ? $request->get('email') : '';
                $district = $request->has('district_level') ? $request->get('district_level') : '';
                $days = $request->has('days') ? $request->get('days') : '';
                // $resolvedOfficer = $request->has('resolvedOfficer') ? $request->get('resolvedOfficer') : '';

                foreach ($levels as $key => $level) {
                    $subData = new EscalationMatrixLevels();
                    $subData->name = $level;
                    $subData->escalation_reference_id = $lastId;
                    $subData->level = $key + 1;
                    $subData->mobile = $mobile[$key];
                    $subData->email = isset($email[$key]) ? $email[$key] : '';
                    $subData->district = $district[$key];
                    $subData->days = $days[$key];
                    // $subData->resolving_officer = $resolvedOfficer[$key];
                    $subData->save();
                    $this->createUserIfNotExists($subData);
                }
                DB::commit();
                return true;
            }

        } catch (\Exception$e) {
            DB::rollback();
            Log::info('escalation form Error : ' . $e);
            throw new \Exception('Error processing request');
        }

    }

    public function createUserIfNotExists($userData)
    {
        $user = User::where('email', $userData->mobile)->count();
        if ($user == 0) {
            $newUser = new User();
            $newUser->name = $userData->name;
            $newUser->email = $userData->mobile;
            $newUser->password = Hash::make($userData->mobile);
            $newUser->role = RoleMaster::ROLE_LEVEL_OFFICER;
            $newUser->user_type = User::USER_TYPE_LEVEL_OFFICER;
            $newUser->save();
        }
    }

}
