<?php

namespace App\Services\Master;

use App\Models\Masters\MenuMaster;
use App\Models\Masters\Privilege;
use App\Models\RoleMaster;
use App\Models\User;
use App\Services\Master\MenuService;
use App\Utilities\AppClass;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Route;
use Session;

class PrivilegeService
{
    private $menuService;

    public function __construct(MenuService $menuService)
    {
        $this->menuService = $menuService;
    }

    public function getData()
    {
        $data = DB::table('privilege')
            ->join('role_master', 'role_master.id', 'privilege.role')
            ->groupBy('privilege.role')
            ->select(
                'role_master.description as role_name', 'privilege.role as id',
                DB::raw('1 as status')
            )
            ->whereNotIn('privilege.role', RoleMaster::HIDDEN_ROLES);
        // ->get();
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $lineItems = Privilege::where('role', $id)->get();
            $data = new AppClass();
            $data->route = route('privileges.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->privilege = $lineItems;
            $data->role_id = $lineItems[0]->role;
            $data->editMode = true;
        } else {
            $data = new Privilege();
            $data->route = route('privileges.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('privileges.index');
        $data->menus = $this->menuService->getMenus('privileges');
        $data->breadcrumbTitle = 'Privileges';
        //make checked menus
        if ($id) {
            $this->makeCheckBoxSelected($data);
        }

        return $data;
    }

    public function makeCheckBoxSelected($data)
    {
        if ($data->menus && $data->privilege) {
            foreach ($data->menus as $mainMenu) {
                foreach ($mainMenu->subMenu as $submenu) {
                    foreach ($data->privilege as $pkey => $privilege) {
                        if ($privilege->menu == $submenu->id) {
                            $submenu = $this->setPrivilegesAttributes($submenu, $privilege);
                        }
                    }
                }
            }
        }
    }

    public function setPrivilegesAttributes($submenu, $privilege)
    {
        $attributes = Privilege::PRIVILEGE_COLUMN_ATTRIBUTES;
        foreach ($attributes as $value) {
            $submenu->$value = $privilege->$value;
        }
        return $submenu;
    }

    public function saveData(HttpRequest $request, $id = null)
    {

        $role = $request->has('role') ? $request->get('role') : '';
        $menu = $request->has('menu') ? $request->get('menu') : '';

        Privilege::where('role', $role)->delete();

        if ($menu) {
            foreach ($menu as $mkey => $mainMenu) {

                $privilege = new Privilege();
                $privilege->role = $role;
                $privilege->menu = $mkey;
                $privilege->created_by = Auth::user()->id;
                $privilege->created_at = Carbon::now();
                $privilege->save();

                foreach ($mainMenu as $key => $menuValue) {
                    $privilege = new Privilege();
                    $privilege->role = $role;
                    $privilege->menu = $key;
                    $privilege->create = isset($menuValue['create']) ? true : false;
                    $privilege->view = isset($menuValue['view']) ? true : false;
                    $privilege->print = isset($menuValue['print']) ? true : false;
                    $privilege->edit = isset($menuValue['edit']) ? true : false;
                    $privilege->active = isset($menuValue['active']) ? true : false;
                    $privilege->inactive = isset($menuValue['inactive']) ? true : false;
                    $privilege->delete = isset($menuValue['delete']) ? true : false;
                    $privilege->import = isset($menuValue['import']) ? true : false;
                    $privilege->export = isset($menuValue['export']) ? true : false;
                    $privilege->approve = isset($menuValue['approve']) ? true : false;
                    $privilege->reject = isset($menuValue['reject']) ? true : false;
                    $privilege->created_by = Auth::user()->id;
                    $privilege->created_at = Carbon::now();
                    $privilege->save();
                }
            }

            //regenerate session menus
            // $this->menuService->getRoleMenus($role);
            return true;
        }

    }

    public function getPrivilegesMenuSql($id)
    {
        $sql = DB::table('privilege')
            ->join('menu_master', 'menu_master.id', 'privilege.menu')
            ->join('role_master', 'role_master.id', 'privilege.role')
            ->where('privilege.role', $id)
            ->where('menu_master.status', MenuMaster::STATUS_ACTIVE)
            ->select('privilege.*', 'menu_master.menu_name', 'menu_master.p_menu', 'menu_master.id as menuId');
        return $sql;
    }

    public function showData($id)
    {
        $data = $this->getPrivilegesMenuSql($id)->where('menu_master.p_menu', 0)->get();
        if ($data) {
            foreach ($data as $menuRow) {
                $menuRow->subMenu = $this->getPrivilegesMenuSql($id)->where('menu_master.p_menu', $menuRow->menuId)->get();
            }
        }
        return $data;
    }

    public function getPrivilegeDetails($type = null)
    {
        Gate::authorize('isMenuAccess');
        $privileges = Session::get('privilege');
        $loggedUserType = Session::get('loggedUser');

        $routeDetails = getMenuIdByRouteName();

        $routeName = $routeDetails->routeName;
        $menuId = $routeDetails->menuId;

        $privilegeColumns = Privilege::PRIVILEGE_COLUMN_ATTRIBUTES;

        if ($menuId) {

            if ($type == 'reports') {
                $routeParameters = getRouteArgsReports($routeName);
            } else {
                $routeParameters = getRouteArgs($routeName);
            }

            if ($loggedUserType == User::LOGGED_USER_SUPER_ADMIN) {

                foreach ($privilegeColumns as $column) {
                    $routeParameters->$column = true;
                }

            } else {
                foreach ($privileges as $privilege) {
                    if ($privilege->menu == $menuId) {
                        foreach ($privilegeColumns as $column) {
                            $routeParameters->$column = $privilege->$column;
                        }
                    }
                }
            }

            return $routeParameters;
        } else {
            //for dashboard detail report show
            $routeParameters = getRouteArgsReports($routeName);
            foreach ($privilegeColumns as $column) {
                $routeParameters->$column = true;
            }
            return $routeParameters;
        }
    }

}
