<?php

namespace App\Services\Master;

use App\Models\ResolveReasons;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class ResolveReasonService
{

    public function __construct()
    {
    }

    public function getData()
    {
        $sql = ResolveReasons::getReasons();
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = ResolveReasons::find($id);
            $data->route = route('resolve-reasons.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new ResolveReasons();
            $data->route = route('resolve-reasons.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('resolve-reasons.index');
        $data->breadcrumbTitle = 'Sector';
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $reasonId = $request->has('reasonId') ? $request->get('reasonId') : '';

        if ($reasonId) {
            $data = ResolveReasons::find($reasonId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new ResolveReasons();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->save();

        if ($data) {
            return true;
        }
    }
}
