<?php

namespace App\Services;


use App\Models\ReferralCampaign;
use App\Models\ReferralCampaignItems;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class ReferralCampaignService
{

    public function __construct() {}

    public function getData()
    {
        $sql = ReferralCampaign::all();
        return $sql;
    }

    public function showData($id)
    {
        $data = ReferralCampaign::find($id);
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = ReferralCampaign::find($id);
            $data->route = route('referral-campaign.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->campaign_validity = Carbon::parse($data->campaign_validity)->format('m/d/Y');
            $referrerFrom = Carbon::parse($data->referrer_from)->format('d/m/Y');
            $referrerTo = Carbon::parse($data->referrer_to)->format('d/m/Y');
            // $beneficiaryFrom = Carbon::parse($data->beneficiary_from)->format('d/m/Y');
            // $beneficiaryTo = Carbon::parse($data->beneficiary_to)->format('d/m/Y');
            $data->referrer_from_to = $referrerFrom . ' - ' . $referrerTo;
            // $data->beneficiary_from_to = $beneficiaryFrom . ' - ' . $beneficiaryTo;
            $data->items = ReferralCampaignItems::where('campaign_id', $id)->get();
        } else {
            $data = new ReferralCampaign();
            $data->route = route('referral-campaign.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
            $data->items = [];
        }
        $data->breadcrumbAction = route('referral-campaign.index');
        $data->breadcrumbTitle = 'Referral Campaign';
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $campaignValidity = $request->has('campaignValidity') ? Carbon::parse($request->get('campaignValidity')) : '';
        $referrerGet = $request->has('referrerGet') ? $request->get('referrerGet') : '';
        $referrerValue = $request->has('referrerValue') ? $request->get('referrerValue') : '';
        // $referrerVoucherValue = $request->has('referrerVoucherValue') ? $request->get('referrerVoucherValue') : '';
        $referrerFromTo = $request->has('referrerFromTo') ? $request->get('referrerFromTo') : '';
        // $beneficiaryGet = $request->has('beneficiaryGet') ? $request->get('beneficiaryGet') : '';
        $beneficiaryValue = $request->has('beneficiaryValue') ? $request->get('beneficiaryValue') : null;
        // $beneficiaryVoucherValue = $request->has('beneficiaryVoucherValue') ? $request->get('beneficiaryVoucherValue') : null;
        // $beneficiaryFromTo = $request->has('beneficiaryFromTo') ? $request->get('beneficiaryFromTo') : null;
        $afterReferral = $request->has('afterReferral') ? $request->get('afterReferral') : null;


        $referrerFrom = Carbon::now();
        $referrerTo = Carbon::now();
        // $beneficiaryFrom = Carbon::now();
        // $beneficiaryTo = Carbon::now();

        $referrerFromTo = explode('-', $referrerFromTo);
        // $beneficiaryFromTo = explode('-', $beneficiaryFromTo);

        if (isset($referrerFromTo[0]) && $referrerFromTo[0] != '') {
            $fromDate = str_replace('/', '-', trim($referrerFromTo[0]));
            $referrerFrom = Carbon::parse($fromDate);
        }
        if (isset($referrerFromTo[1]) && $referrerFromTo[1] != '') {
            $toDate = str_replace('/', '-', trim($referrerFromTo[1]));
            $referrerTo = Carbon::parse($toDate);
        }

        // if (isset($beneficiaryFromTo[0]) && $beneficiaryFromTo[0] != '') {
        //     $fromDate = str_replace('/', '-', trim($beneficiaryFromTo[0]));
        //     $beneficiaryFrom = Carbon::parse($fromDate);
        // }
        // if (isset($beneficiaryFromTo[1]) && $beneficiaryFromTo[1] != '') {
        //     $toDate = str_replace('/', '-', trim($beneficiaryFromTo[1]));
        //     $beneficiaryTo = Carbon::parse($toDate);
        // }

        if ($id) {
            $data = ReferralCampaign::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new ReferralCampaign();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->campaign_validity = $campaignValidity;
        $data->referrer_get = $referrerGet;
        $data->referrer_value = $referrerValue;
        // $data->referrer_voucher_value = $referrerVoucherValue;
        $data->referrer_from = $referrerFrom;
        $data->referrer_to = $referrerTo;
        // $data->beneficiary_get = $beneficiaryGet;
        $data->beneficiary_value = $beneficiaryValue;
        // $data->beneficiary_voucher_value = $beneficiaryVoucherValue;
        // $data->beneficiary_from = $beneficiaryFrom;
        // $data->beneficiary_to = $beneficiaryTo;
        if ($data->save()) {
            ReferralCampaignItems::where('campaign_id', $data->id)->delete();
            foreach ($afterReferral as $row) {
                $item = new ReferralCampaignItems();
                $item->campaign_id = $data->id;
                $item->amount = $row;
                $item->save();
            }
            return true;
        }
    }
}
