<?php

namespace App\Services\Reports;

use App\Models\Masters\AgentMaster;
use App\Services\DashboardService;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;
use stdClass;

class AgentwiseCallsService
{
    private $reportService;
    private $excelExportService;
    private $dashboardService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService, DashboardService $dashboardService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
        $this->dashboardService = $dashboardService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);

        $sql = AgentMaster::select(
            'agent_master.id',
            'branch_master.name as branchName',
            'agent_master.name as agentName',
            'designation_master.name as designation',
        )
            ->leftJoin('branch_master', 'agent_master.branch_id', 'branch_master.id')
            ->leftJoin('designation_master', 'agent_master.designation', 'designation_master.id')
            ->where('agent_master.status', AgentMaster::STATUS_ACTIVE)
            ->groupBy('agent_master.id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        if ($args->agent && $args->agent != 'All') {
            $sql->where('agent_master.id', $args->agent);
        }
        $agentMaster =   $sql->get();

        $agent = 'All';
        $branch = 'All';
        if ($args->branch > 0) {
            $branch = $args->branch;
        }
        if ($args->agent > 0) {
            $agent = $args->agent;
        }
        $params = clone $args;
        $params->agent = $agent;
        $params->branch = $branch;
        $params->source = null;

        $sql = $this->dashboardService->coreAgentCallDetails($params);
        $sql->select(
            'beneficiary_import.agent_id',
            DB::raw('COUNT(feedback.id) as dialledCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as connectedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 2 THEN feedback.id END) as notConnectedCalls')
        );
        $sql->groupBy('beneficiary_import.agent_id');
        $feedback = $sql->get();

        $assSql = $this->dashboardService->coreAgentAssignFollowDetails($params);
        $assigned = $assSql->select(
            'beneficiary_import.agent_id',
            DB::raw('COUNT(beneficiary_import.id) as totalCalls'),
        )
            ->groupBy('beneficiary_import.agent_id')
            ->get();

        foreach ($agentMaster as $agentRow) {

            $agentRow->dialledCalls = 0;
            $agentRow->connectedCalls = 0;
            $agentRow->notConnectedCalls = 0;
            $agentRow->allocatedCalls = 0;

            foreach ($feedback as $feedbackRow) {
                if ($agentRow->id == $feedbackRow->agent_id) {
                    $agentRow->dialledCalls = $feedbackRow->dialledCalls;
                    $agentRow->connectedCalls = $feedbackRow->connectedCalls;
                    $agentRow->notConnectedCalls = $feedbackRow->notConnectedCalls;
                }
            }

            foreach ($assigned as $assignedRow) {
                if ($agentRow->id == $assignedRow->agent_id) {
                    $agentRow->allocatedCalls = $assignedRow->totalCalls;
                }
            }
        }

        return $agentMaster;
    }

    function getReportExcel(Request $request)
    {
        $data = $this->getData($request);
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'agentwise-calls-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->agentLabel = $this->reportService->getAgentById($args->agent);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
