<?php

namespace App\Services\Reports;

use App\Models\Feedback;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;

class ConnectedConvertedReportService
{
    private $reportService;
    private $excelExportService;
    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $sql = Feedback::select(
            'branch_master.name as branchName',
            'agent_master.name as agentName',
            'beneficiary_import.customer_name',
            'beneficiary_import.mobile_number',
            'call_skip_reason.name as callReason',
            'call_skip_reason.dispositions',
            'feedback.remarks',
            'cluster_master.name as clusterName',
            DB::raw('DATE_FORMAT(feedback.created_at, "%d-%m-%Y") as date'),
            DB::raw('DATE_FORMAT(feedback.call_back_date_time, "%d-%m-%Y %h:%i %p") as callbackDate'),
        )
            ->join('beneficiary_import', 'beneficiary_import.id', 'feedback.beneficiary_ref_id')
            ->join('call_skip_reason', 'call_skip_reason.id', 'feedback.call_skip_reason')
            ->join('agent_master', 'agent_master.id', 'feedback.created_by')
            ->join('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'agent_master.branch_id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id')
            ->where('feedback.call_status', 1)
            ->where('call_skip_reason.is_answered', 1)
            ->where('call_skip_reason.dispositions', 'Interested')
            ->whereNull('call_skip_reason.deleted_at')
            ->where('feedback.created_at', '>=', $args->fromDate)
            ->where('feedback.created_at', '<=', $args->toDate);
        if ($args->branch && $args->branch != 'All') {
            $sql->where('beneficiary_import.branch_id', $args->branch);
        }
        if ($args->agent && $args->agent != 'All') {
            $sql->where('feedback.created_by', $args->agent);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        return $sql;
    }

    function getConnectedReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'connected-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        $params->agentLabel = $this->reportService->getAgentById($args->agent);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
