<?php

namespace App\Services\Reports;

use App\Models\EnquiryHistory;
use App\Models\Sales;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class EnquiryReportService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $sql = EnquiryHistory::select(
            'branch_master.name as branchName',
            'enquiry_history.*',
            'cluster_master.name as clusterName',
            DB::raw('DATE_FORMAT(enquiry_history.date, "%d-%m-%Y") as date'),
            DB::raw('
            CASE 
                WHEN enquiry_history.status = 2 THEN "Converted"
                WHEN enquiry_history.status = 3 THEN "Not Interested"
                ELSE "Pending"
            END as leadStatus
        '),
            DB::raw('
            CASE 
                WHEN enquiry_history.read_status = 1 THEN "Seen"
                WHEN enquiry_history.read_status = 2 THEN "Called"
                ELSE "Pending"
            END as readStatus
        ')
        )
            ->leftJoin('branch_master', 'branch_master.id', 'enquiry_history.branch_id')
            ->where('enquiry_history.date', '>=', Carbon::parse($args->fromDate)->format('Y-m-d'))
            ->where('enquiry_history.date', '<=', Carbon::parse($args->toDate)->format('Y-m-d'))
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'branch_master.id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('enquiry_history.branch_id', $args->branch);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        return $sql;
    }

    function getEnquiryReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'enquiry-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
