<?php

namespace App\Services\Reports;

use App\Models\Feedback;
use Illuminate\Http\Request;
use App\Services\Reports\ReportService;
use DB;

class ResolvedReportService
{
    private $reportService;
    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $data = $this->getReport($args);
        return $data;
    }

    public function getReport($args)
    {
        $sql = DB::table('beneficiary_import')
            ->join('feedback', 'feedback.beneficiary_ref_id', 'beneficiary_import.id')
            ->leftJoin('city_master', 'city_master.id', 'beneficiary_import.district_id')
            ->leftJoin('scheme_master', 'scheme_master.id', 'beneficiary_import.scheme_id')
            ->leftJoin('program_master', 'program_master.id', 'beneficiary_import.program_id')
            ->leftJoin('users', 'users.id', 'feedback.resolved_by')
            ->leftJoin('resolve_reasons', 'resolve_reasons.id', 'feedback.resolve_reason')
            ->where('feedback.status', Feedback::STATUS_ACTIVE)
            ->where('feedback.is_compliant', Feedback::IS_COMPLIANT)
            ->where('feedback.is_show', 1)
            ->where('feedback.resolved_status', Feedback::RESOLVED_STATUS_RESOLVED)
            ->whereNull('beneficiary_import.deleted_at');

        $sql->select(
            'feedback.feedback_no',
            'beneficiary_import.customer_name',
            'beneficiary_import.mobile_number',
            'city_master.name as cityName',
            'users.name as resolvedBy',
            'feedback.resolved_level',
            'resolve_reasons.name as resolvedReason',
            'program_master.name as programName',
            'feedback.resolved_at as created_at',
            'feedback.resolved_remarks as resolvedRemarks',
            DB::raw('CONCAT(SUBSTRING(feedback.resolved_remarks,1,20),"...") as resolved_remarks')
        );
        if ($args->scheme) {
            $sql->where('beneficiary_import.scheme_id', $args->scheme);
        }
        if ($args->program) {
            $sql->where('beneficiary_import.program_id', $args->program);
        }
        if ($args->district) {
            $sql->where('beneficiary_import.district_id', $args->district);
        }
        if ($args->fromDate && $args->toDate) {
            $sql->whereDate('feedback.resolved_at', '>=', $args->fromDate);
            $sql->whereDate('feedback.resolved_at', '<=', $args->toDate);
        }

        return $sql;
    }
}
